-- User Group Seed Data

insert  into `user_groups`(`id`,`userGroupName`,`lastUpdate`,`lastUpdatedBy`,`version`) values (1,'Admin','2014-04-27 14:40:04',NULL,0);
insert  into `user_groups`(`id`,`userGroupName`,`lastUpdate`,`lastUpdatedBy`,`version`) values (2,'Faculty','2014-04-27 14:39:54',NULL,0);
insert  into `user_groups`(`id`,`userGroupName`,`lastUpdate`,`lastUpdatedBy`,`version`) values (3,'Student','2014-04-27 14:39:54',NULL,0);

-- User Seed Data

insert  into `users`(`id`,`code`,`firstName`,`middleName`,`lastName`,`shortName`,`printName`,`calendarId`,`whetherSystemUser`,`password`,`salt`,`ipAddress`,`lockedOn`,`status`,`lockedStatus`,`lockedReason`,`noOfTimesLocked`,`noOfLoginFailed`,`lastLockReleaseDate`,`totalAutoLogout`,`whetherDeleted`,`totalLoginFailed`, `userGroupId`,`whetherInternal`,`lastUpdatedBy`,`lastUpdate`,`version`,`whetherPasswordReset`) values (1,'SYSADMIN','System Admin','System Admin','System Admin','System Admin','System Admin',NULL,'','6132b021d89ccca3b52fc3d9cc217958cbbb9d73b90d01bce87b87314571913b','3@sf6',NULL,'2014-11-10 12:26:59','','\0',NULL,0,0,NULL,NULL,'\0',NULL,1,'',1,'2014-11-11 12:25:59',0,'\0');

-- Person Seed Data
insert  into `persons`(`id`,`mobileNumber`,`employeeId`,`firstName`,`middleName`,`emailId`,`lastName`,`shortName`,`birthDate`,`bloodGroup`,`bankDetailId`,`gender`,`maritalStatus`,`category`,`occupation`,`personalIncome`,`photoUrl`,`salutationId`,`castCategoryId`,`nationalityId`,`whetherEmployeeOfOrganization`,`whetherDeleted`,`lastUpdatedBy`,`lastUpdate`,`version`,`countryId`,`printName`,`religionId`) values (1,'982365654155',NULL,'System Admin','System Admin',NULL,'System Admin',NULL,'2014-10-22',NULL,NULL,'MALE',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'\0',1,'2014-11-10 11:47:51',0,NULL,NULL,NULL);

-- Staff Seed Data
insert  into `staffs`(`userId`,`personId`,`departmentId`,`subDepartmentId`,`designationId`,`whetherFaculty`,`whetherActivated`,`facultyType`,`joiningDate`,`exitDate`,`yearsOfExperience`) values (1,1,NULL,NULL,NULL,'\0',NULL,NULL,NULL,NULL,NULL);


-- Address Type Seed Data
INSERT INTO `address_type`(`code`,`addressTypeName`,`addressCategory`,`lastUpdatedBy`,`lastUpdate`,`version`) VALUES ('REG','Registered','ORG',1,'2014-03-05 07:18:13',0);
INSERT INTO `address_type`(`code`,`addressTypeName`,`addressCategory`,`lastUpdatedBy`,`lastUpdate`,`version`) VALUES ('RES','Residential','ORG',1,'2014-03-05 07:18:16',0);
INSERT INTO `address_type`(`code`,`addressTypeName`,`addressCategory`,`lastUpdatedBy`,`lastUpdate`,`version`) VALUES ('REG','Registered','LOC',1,'2014-03-05 07:18:18',0);
INSERT INTO `address_type`(`code`,`addressTypeName`,`addressCategory`,`lastUpdatedBy`,`lastUpdate`,`version`) VALUES ('RES','Residential','LOC',1,'2014-03-05 07:18:22',0);
INSERT INTO `address_type`(`code`,`addressTypeName`,`addressCategory`,`lastUpdatedBy`,`lastUpdate`,`version`) VALUES ('CRNT','Current','PERSON',1,'2014-07-17 13:19:58',0);
INSERT INTO `address_type`(`code`,`addressTypeName`,`addressCategory`,`lastUpdatedBy`,`lastUpdate`,`version`) VALUES ('CRSPDNC','Correspondance','PERSON',1,'2014-07-18 07:09:25',0);
INSERT INTO `address_type`(`code`,`addressTypeName`,`addressCategory`,`lastUpdatedBy`,`lastUpdate`,`version`) VALUES ('PRMNT','Permanent','PERSON',1,'2014-07-17 13:32:50',0);
INSERT INTO `address_type`(`code`,`addressTypeName`,`addressCategory`,`lastUpdatedBy`,`lastUpdate`,`version`) VALUES ('OFC','Office','PERSON',1,'2014-07-17 13:33:29',0);
INSERT INTO `address_type`(`code`,`addressTypeName`,`addressCategory`,`lastUpdatedBy`,`lastUpdate`,`version`) VALUES('OFC','Office','ORG',1,'2014-11-12 14:00:00',0);
INSERT INTO `address_type`(`code`,`addressTypeName`,`addressCategory`,`lastUpdatedBy`,`lastUpdate`,`version`) VALUES ('CRNT','Current','ACDLOC',1,'2017-08-21 18:00:00',0);
INSERT INTO `address_type`(`code`,`addressTypeName`,`addressCategory`,`lastUpdatedBy`,`lastUpdate`,`version`) VALUES ('CRSPDNC','Correspondance','ACDLOC',1,'2017-08-21 18:00:00',0);
INSERT INTO `address_type`(`code`,`addressTypeName`,`addressCategory`,`lastUpdatedBy`,`lastUpdate`,`version`) VALUES ('PRMNT','Permanent','ACDLOC',1,'2017-08-21 18:00:00',0);
INSERT INTO `address_type`(`code`,`addressTypeName`,`addressCategory`,`lastUpdatedBy`,`lastUpdate`,`version`) VALUES ('OFC','Office','ACDLOC',1,'2017-08-21 18:00:00',0);

-- Role Management Seed Data
insert  into `roles`(`roleName`,`roleDesc`,`whetherDeletable`,`createdOn`,`whetherEditable`,`whetherDeleted`,`serialNumber`,`lastUpdatedBy`,`lastUpdate`,`version`) 
values ('STUDENT','Student','\0','2014-05-12','','\0','1',1,'2014-05-12 16:24:40',0);
insert  into `roles`(`roleName`,`roleDesc`,`whetherDeletable`,`createdOn`,`whetherEditable`,`whetherDeleted`,`serialNumber`,`lastUpdatedBy`,`lastUpdate`,`version`) 
values ('FACULTY','Student','\0','2014-05-15','','\0','2',1,'2014-05-15 11:34:40',0);
insert  into `roles`(`roleName`,`roleDesc`,`whetherDeletable`,`createdOn`,`whetherEditable`,`whetherDeleted`,`serialNumber`,`lastUpdatedBy`,`lastUpdate`,`version`) 
values ('HOD','HOD','\0','2014-05-15','\0','\0','3',1,'2014-05-15 11:36:01',0);
insert  into `roles`(`roleName`,`roleDesc`,`whetherDeletable`,`createdOn`,`whetherEditable`,`whetherDeleted`,`serialNumber`,`lastUpdatedBy`,`lastUpdate`,`version`) 
values ('OWNER','Owner','\0','2014-05-15','\0','\0','4',1,'2014-05-15 11:37:33',0);
insert  into `roles` (`roleName`, `roleDesc`, `whetherDeletable`, `createdOn`, `whetherEditable`, `whetherDeleted`, `serialNumber`, `lastUpdatedBy`, `lastUpdate`, `version`) 
values ('Add Saved Search Report', 'Add Saved Search Report', '\0', '2015-05-18', '\0', '\0', '5', '1', '2015-05-18 15:08:55', '0');


-- added by Pushpendra in support of examination module
SET @idRolesSerialNumber=(SELECT MAX(serialNumber) FROM roles);
INSERT INTO roles (roleName, roleDesc, whetherDeletable, createdOn, whetherEditable, whetherDeleted, serialNumber, lastUpdatedBy, lastUpdate, version)
VALUES ('INVIGILATOR', 'Invigilator', 0, CURDATE(), 0, 0, @idRolesSerialNumber+1, 1, now(), 0);

SET @idRolesSerialNumber=(SELECT MAX(serialNumber) FROM roles);
INSERT INTO roles (roleName, roleDesc, whetherDeletable, createdOn, whetherEditable, whetherDeleted, serialNumber, lastUpdatedBy, lastUpdate, version)
VALUES ('EXAMINER', 'Examiner', 0, CURDATE(), 0, 0, @idRolesSerialNumber+1, 1, now(), 0);

SET @idRolesSerialNumber=(SELECT MAX(serialNumber) FROM roles);
INSERT INTO roles (roleName, roleDesc, whetherDeletable, createdOn, whetherEditable, whetherDeleted, serialNumber, lastUpdatedBy, lastUpdate, version)
VALUES ('REVIEWER', 'Reviewer', 0, CURDATE(), 0, 0, @idRolesSerialNumber+1, 1, now(), 0);

SET @idRolesSerialNumber=(SELECT MAX(serialNumber) FROM roles);
INSERT INTO roles (roleName, roleDesc, whetherDeletable, createdOn, whetherEditable, whetherDeleted, serialNumber, lastUpdatedBy, lastUpdate, version)
VALUES ('PAPER_SETTER', 'Paper Setter', 0, CURDATE(), 0, 0, @idRolesSerialNumber+1, 1, now(), 0);

SET @idRolesSerialNumber=(SELECT MAX(serialNumber) FROM roles);
INSERT INTO roles (roleName, roleDesc, whetherDeletable, createdOn, whetherEditable, whetherDeleted, serialNumber, lastUpdatedBy, lastUpdate, version)
VALUES ('CENTER_SUPERVISOR', 'Center Supervisor', 0, CURDATE(), 0, 0, @idRolesSerialNumber+1, 1, now(), 0);

SET @idRolesSerialNumber=(SELECT MAX(serialNumber) FROM roles);
INSERT INTO roles (roleName, roleDesc, whetherDeletable, createdOn, whetherEditable, whetherDeleted, serialNumber, lastUpdatedBy, lastUpdate, version)
VALUES ('REVALUER', 'Revaluer', 0, CURDATE(), 0, 0, @idRolesSerialNumber+1, 1, now(), 0);

SET @idRolesSerialNumber=(SELECT MAX(serialNumber) FROM roles);
INSERT INTO roles (roleName, roleDesc, whetherDeletable, createdOn, whetherEditable, whetherDeleted, serialNumber, lastUpdatedBy, lastUpdate, version)
VALUES ('RESULT_APPROVER', 'Result Approver', 0, CURDATE(), 0, 0, @idRolesSerialNumber+1, 1, now(), 0);

SET @idRolesSerialNumber=(SELECT MAX(serialNumber) FROM roles);
INSERT INTO roles (roleName, roleDesc, whetherDeletable, createdOn, whetherEditable, whetherDeleted, serialNumber, lastUpdatedBy, lastUpdate, version)
VALUES ('APPROVER', 'Approver', 0, CURDATE(), 0, 0, @idRolesSerialNumber+1, 1, now(), 0);

SET @idRolesSerialNumber=(SELECT MAX(serialNumber) FROM roles);
INSERT INTO roles (roleName, roleDesc, whetherDeletable, createdOn, whetherEditable, whetherDeleted, serialNumber, lastUpdatedBy, lastUpdate, version)
VALUES ('SURVEY ADMIN', 'Survey Admin', 0, CURDATE(), 0, 0, @idRolesSerialNumber+1, 1, now(), 0);

-- Portal Seed Data
insert  into `portals`(`id`,`portalName`,`portalDesc`,`lastUpdatedBy`,`lastUpdate`,`version`) values (1,'Core ERP','Core ERP',1,'2014-03-03 18:30:00',0),(2,'Faculty','Faculty',1,'2014-03-03 18:30:00',0),(3,'Student','Student',1,'2014-03-03 18:30:00',0),(4,'External User','External User',1,'2014-03-03 18:30:00',0);
insert  into `role_portals`(`id`,`roleId`,`portalId`,`lastUpdate`,`lastUpdatedBy`) values (1,1,3,'2014-05-12 17:31:16',1);
insert  into `role_portals`(`id`,`roleId`,`portalId`,`lastUpdate`,`lastUpdatedBy`) values (2,2,2,'2014-05-20 17:31:31',1);
insert  into `role_portals`(`id`,`roleId`,`portalId`,`lastUpdate`,`lastUpdatedBy`) values (3,3,2,'2014-05-20 17:31:47',1);
SET @idRole=(SELECT MAX(id) FROM roles);
insert  into `role_portals`(`roleId`,`portalId`,`lastUpdate`,`lastUpdatedBy`) values (@idRole, 1, now(), 1);

-- Privilege Seed Data
insert  into `privilege`(`id`,`version`,`description`,`displayCode`,`code`,`privilegeName`,`lastUpdatedBy`,`lastUpdate`) 
values ('1','0','create ','Create','CREATE','Create','1','2014-03-03 18:30:00'),
(2,0,'update','Update','UPDATE','Update',1,'2014-03-03 18:30:00'),
(3,0,'delete','Delete','DELETE','Delete',1,'2014-03-03 18:30:00'),
(4,0,'view','View','VIEW','View',1,'2014-03-03 18:30:00'),
(5,0,'export','Export','EXPORT','Export',1,'2014-03-03 18:30:00'),
(6,0,'execute','Execute','EXECUTE','Execute',1,'2014-03-03 18:30:00'),
(7,0,'import','Import','IMPORT','Import',1,'2014-03-03 18:30:00'),
(8,0,'NEW','NEW','NEW','New',1,'2014-04-10 10:44:05'),
(9,0,'moreAction','MoreActions','MOREACTIONS','MoreAction',1,'2014-10-03 18:30:00'),
(10,0,'sendMessage','SendMessage','SENDMESSAGE','SendMessage',1,'2014-10-03 18:30:00'),
(11,0,'viewDocuments','ViewDocuments','VIEWDOCUMENTS','ViewDocuments',1,'2014-10-03 18:30:00'),
(12,0,'checkDuplicateName','CheckDuplicateName','CHECKDUPLICATENAME','CheckDuplicateName',1,'2014-10-03 18:30:00'),
(13,0,'checkDuplicateEmail','CheckDuplicateEmail','CHECKDUPLICATEEMAIL','CheckDuplicateEmail',1,'2014-10-03 18:30:00'),
(14,0,'checkDuplicateMobile','CheckDuplicateMobile','CHECKDUPLICATEMOBILE','CheckDuplicateMobile',1,'2014-10-03 18:30:00'),
(15,0,'checkDuplicatePhone','CheckDuplicatePhone','CHECKDUPLICATEPHONE','checkDuplicatePhone',1,'2014-10-03 18:30:00'),
(16,0,'applicableFor','ApplicableFor','APPLICABLEFOR','ApplicableFor',1,'2014-10-03 18:30:00'),
(17,0,'viewUnmapped','ViewUnmapped','VIEWUNMAPPED','ViewUnmapped',1,'2014-10-03 18:30:00'),
(18,0,'viewCoverage','ViewCoverage','VIEWCOVERAGE','ViewCoverage',1,'2014-10-03 18:30:00'),
(19,0,'approve','Approve','APPROVE','Approve',1,'2014-10-03 18:30:00'),
(20,0,'personCovered','PersonCovered','PERSONCOVERED','PersonCovered',1,'2014-10-03 18:30:00'),
(21,0,'configureFeeHead','ConfigureFeeHead','CONFIGUREFEEHEAD','ConfigureFeeHead',1,'2014-10-03 18:30:00'),
(22,0,'uploadFile','UploadFile','UPLOADFILE','UploadFile',1,'2014-10-03 18:30:00'),
(23,0,'copy','Copy','COPY','Copy',1,'2014-10-03 18:30:00'),
(24,0,'assign','Assign','ASSIGN','Assign',1,'2014-10-03 18:30:00'),
(25,0,'viewPastRecord','ViewPastRecord','VIEWPASTRECORD','ViewPastRecord',1,'2014-10-03 18:30:00'),
(26,0,'manageSession','ManageSession','MANAGESESSION','ManageSession',1,'2014-10-31 00:00:00'),
(27,0,'discountEntry','DiscountEntry','DISCOUNTENTRY','DiscountEntry',1,'2014-10-31 00:00:00'),
(28,0,'viewCalculateDFH','ViewCalculateDFH','VIEWCALCULATEDFH','ViewCalculateDFH',1,'2014-10-31 00:00:00'),
(29,0,'addCoverageDetails','AddCoverageDetails','ADDCOVERAGEDETAILS','AddCoverageDetails',1,'2014-11-05 00:00:00'),
(30,0,'addNewSession','AddNewSession','ADDNEWSESSION','AddNewSession',1,'2014-11-05 00:00:00'),
(31,0,'viewCalendar','ViewCalendar','VIEWCALENDAR','ViewCalendar',1,'2014-11-05 00:00:00');

INSERT INTO  `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('32', '0', 'addEditTopicDetails', 'AddEditTopicDetails', 'ADDEDITTOPICDETAILS', 'AddEditTopicDetails', '1', '2014-11-05 00:00:00');
INSERT INTO  `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('33', '0', 'schedulePayment', 'SchedulePayment', 'SCHEDULEPAYMENT', 'SchedulePayment', '1', '2014-10-14 00:00:00');
INSERT INTO  `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('34', '0', 'manageDependentFeeHead', 'ManageDependentFeeHead', 'MANAGEDEPENDENTFEEHEAD', 'ManageDependentFeeHead', '1', '2014-11-14 00:00:00');
INSERT INTO  `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('35', '0', 'Upload Document', 'Upload Document', 'Upload Document', 'Upload Document', '1', '2014-11-14 00:00:00');
INSERT INTO  `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('36', '0', 'addFacultyBtnItemId', 'AddFaculty', 'ADDFACULTY', 'AddFaculty', '1', '2014-11-18 00:00:00');
INSERT INTO  `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('37', '0', 'manageDiscount', 'ManageDiscount', 'MANAGEDISCOUNT', 'ManageDiscount', '1', '2014-11-14 00:00:00');
INSERT INTO  `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('38', '0', 'Configure Group', 'Configure Group', 'Configure Group', 'Configure Group', '1', '2014-12-17 00:00:00');
INSERT INTO  `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('39', '0', 'viewConfigure', 'ViewConfigure', 'VIEWCONFIGURE', 'ViewConfigure', '1', '2014-12-17 00:00:00');
INSERT INTO  `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('40', '0', 'Copy Configuration Combination', 'Copy Configuration Combination', 'Copy Configuration Combination', 'Copy Configuration Combination', '1', '2014-12-17 00:00:00');
INSERT INTO  `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('41', '0', 'findApplicant', 'FindApplicant', 'FINDAPPLICANT', 'FindApplicant', '1', '2014-12-17 00:00:00');
INSERT INTO  `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('42', '0', 'Assign Application ID', 'Assign Application ID', 'Assign Application ID', 'Assign Application ID', '1', '2014-12-17 00:00:00');
INSERT INTO  `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('43', '0', 'Collect Payment', 'Collect Payment', 'Collect Payment', 'Collect Payment', '1', '2014-12-17 00:00:00');
INSERT INTO  `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('44', '0', 'search', 'Search', 'SEARCH', 'Search', '1', '2014-12-17 00:00:00');
INSERT INTO  `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('45', '0', 'mapChecklist', 'MapChecklist', 'MAPCHECKLIST', 'MapChecklist', '1', '2014-12-17 00:00:00');
INSERT INTO  `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('46', '0', 'mapCertificate', 'MapCertificate', 'MAPCERTIFICATE', 'MapCertificate', '1', '2014-12-17 00:00:00');
INSERT INTO  `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('47', '0', 'updatePriority', 'UpdatePriority', 'UPDATEPRIORITY', 'UpdatePriority', '1', '2014-12-18 00:00:00');
INSERT INTO  `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('48', '0', 'addProgram', 'AddProgram', 'ADDPROGRAM', 'AddProgram', '1', '2014-12-18 00:00:00');
INSERT INTO  `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('49', '0', 'confirmDenyAdmission', 'ConfirmDenyAdmission', 'CONFIRMDENYADMISSION', 'ConfirmDenyAdmission', '1', '2014-12-18 00:00:00');
INSERT INTO  `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('50', '0', 'confirmWithdrawAdmission', 'ConfirmWithdrawAdmission', 'CONFIRMWITHDRAWADMISSION', 'ConfirmWithdrawAdmission', '1', '2014-12-18 00:00:00');
INSERT INTO  `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('51', '0', 'enterMarks', 'EnterMarks', 'ENTERMARKS', 'EnterMarks', '1', '2014-12-18 00:00:00');
INSERT INTO  `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('52', '0', 'importMarks', 'ImportMarks', 'IMPORTMARKS', 'ImportMarks', '1', '2014-12-18 00:00:00');
INSERT INTO  `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('53', '0', 'changeStatus', 'ChangeStatus', 'CHANGESTATUS', 'ChangeStatus', '1', '2014-12-18 00:00:00');
INSERT INTO  `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('54', '0', 'overRideQuotaLimit', 'OverRideQuotaLimit', 'OVERRIDEQUOTALIMIT', 'OverRideQuotaLimit', '1', '2014-12-18 00:00:00');
INSERT INTO  `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('55', '0', 'transferSeats', 'TransferSeats', 'TRANSFERSEATS', 'TransferSeats', '1', '2014-12-18 00:00:00');
INSERT INTO  `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('56', '0', 'previewChange', 'PreviewChange', 'PREVIEWCHANGE', 'PreviewChange', '1', '2014-12-18 00:00:00');
INSERT INTO  `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('57', '0', 'applySeatTransfer', 'ApplySeatTransfer', 'APPLYSEATTRANSFER', 'ApplySeatTransfer', '1', '2014-12-18 00:00:00');
INSERT INTO  `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('58', '0', 'addColumn', 'AddColumn', 'ADDCOLUMN', 'AddColumn', '1', '2014-12-18 00:00:00');
INSERT INTO  `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('59', '0', 'studentRoomAllocation', 'StudentRoomAllocation', 'STUDENTROOMALLOCATION', 'StudentRoomAllocation', '1', '2014-12-18 00:00:00');
INSERT INTO  `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('60', '0', 'assignInvigilator', 'AssignInvigilator', 'ASSIGNINVIGILATOR', 'AssignInvigilator', '1', '2014-12-18 00:00:00');
INSERT INTO  `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('61', '0', 'approve', 'Approve', 'APPROVE', 'Approve', '1', '2014-12-18 00:00:00');
INSERT INTO  `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('62', '0', 'withdrawn', 'Withdrawn', 'WITHDRAWN', 'Withdrawn', '1', '2014-12-18 00:00:00');
INSERT INTO  `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('63', '0', 'hallticketgeneration', 'HallTicketGeneration', 'HALLTICKETGENERATION', 'HallTicketGeneration', '1', '2014-12-18 00:00:00');
INSERT INTO  `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('64', '0', 'printhallticket', 'PrintHallTicket', 'PRINTHALLTICKET', 'PrintHallTicket', '1', '2014-12-18 00:00:00');
INSERT INTO  `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('65', '0', 'notify', 'Notify', 'NOTIFY', 'Notify', '1', '2014-12-18 00:00:00');
INSERT INTO  `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('66', '0', 'downloadapplication', 'DownloadApplication', 'DOWNLOADAPPLICATION', 'DownloadApplication', '1', '2014-12-18 00:00:00');
INSERT INTO  `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('67', '0', 'print', 'Print', 'PRINT', 'Print', '1', '2015-01-22 00:00:00');
INSERT INTO  `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('68', '0', 'promoteRetain', 'promoteRetain', 'PROMOTERETAIN', 'promoteRetain', '1', '2015-1-23 00:00:00');
INSERT INTO  `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('69', '0', 'Save Reordering', 'Save Reordering', 'Save Reordering', 'Save Reordering', '1', '2015-1-30 00:00:00');
INSERT INTO  `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('70', '0', 'cancelSettlements', 'CancelSettlements', 'CANCELSETTLEMENTS', 'CancelSettlements', '1', '2015-03-24 00:00:00');
INSERT INTO  `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('71', '0', 'savButton', 'SaveButton', 'SAVEBUTTON', 'SaveButton', '1', '2015-03-24 00:00:00');
INSERT INTO  `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('72', '0', 'review', 'Review', 'REVIEW', 'Review', '1', '2015-03-24 00:00:00');
INSERT INTO `privilege`  (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('73', '0', 'defaulttemplate', 'DefaultTemplate', 'DEFAULTTEMPLATE', 'DefaultTemplate', '1', '2015-04-16 00:00:00');
INSERT INTO `privilege`  (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('74', '0', 'approveapplication', 'ApproveApplication', 'APPROVEAPPLICATION', 'ApproveApplication', '1', '2015-04-16 00:00:00');
INSERT INTO `privilege`  (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('75', '0', 'rejectapplication', 'RejectApplication', 'REJECTAPPLICATION', 'RejectApplication', '1', '2015-04-16 00:00:00');
INSERT INTO `privilege`  (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('76', '0', 'withdrawapplication', 'WithdrawApplication', 'WITHDRAWAPPLICATION', 'WithdrawApplication', '1', '2015-04-16 00:00:00');
INSERT INTO `privilege`  (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('77', '0', 'withdrawadmission', 'WithdrawAdmission', 'WITHDRAWADMISSION', 'WithdrawAdmission', '1', '2015-04-16 00:00:00');
INSERT INTO `privilege`  (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('78', '0', 'rejectadmission', 'RejectAdmission', 'REJECTADMISSION', 'RejectAdmission', '1', '2015-04-16 00:00:00');
INSERT INTO `privilege`  (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('79', '0', 'approveadmission', 'ApproveAdmission', 'APPROVEADMISSION', 'ApproveAdmission', '1', '2015-04-16 00:00:00');
INSERT INTO `privilege`  (`id`,`version` , `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('80', '0', 'associateStudent', 'AssociateStudent', 'ASSOCIATESTUDENT', 'AssociateStudent', '1', '2015-04-29 00:00:00');
INSERT INTO `privilege`  (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('81', '0', 'submitandGenerateToken', 'SubmitandGenerateToken', 'SUBMITANDGENERATETOKEN', 'SubmitandGenerateToken', '1', '2015-05-04 00:00:00');
INSERT INTO `privilege`  (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('82', '0', 'resetPassword', 'ResetPassword', 'RESETPASSWORD', 'ResetPassword', '1', '2015-05-22 00:00:00');

INSERT INTO `privilege`  (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('83', '0', 'insuranceHistory', 'Insurance History', 'INSURANCEHISTORY', 'Insurance History', '1', '2015-06-04 00:00:00');
INSERT INTO `privilege`  (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('84', '0', 'emissionHistory', 'Emission Check History', 'EMISSIONHISTORY', 'Emission Check History', '1', '2015-06-04 00:00:00');
INSERT INTO `privilege`  (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('85', '0', 'roadTaxHistory', 'Road Tax History', 'ROADTAXHISTORY', 'Road Tax History', '1', '2015-06-04 00:00:00');
INSERT INTO `privilege`  (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('86', '0', 'journeyAssignment', 'Journey Assignment', 'JOURNEYASSIGNMENT', 'Journey Assignment', '1', '2015-06-04 00:00:00');
INSERT INTO `privilege`  (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('87', '0', 'createView', 'CreateView', 'CREATEVIEW', 'CreateView', '1', '2015-07-01 00:00:00');
INSERT INTO `privilege`  (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('88', '0', 'generate', 'Generate', 'GENERATE', 'Generate', '1', '2015-07-01 00:00:00');
INSERT INTO `privilege`  (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('89', '0', 'mapStudents', 'MapStudents', 'MAPSTUDENTS', 'MapStudents', '1', '2015-07-09 00:00:00');
INSERT INTO `privilege`  (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('90', '0', 'generateAndDownloadMarksheet', 'GenerateAndDownloadMarksheet', 'GENERATEANDDOWNLOADMARKSHEET', 'GenerateAndDownloadMarksheet', '1', '2015-07-09 00:00:00');
INSERT INTO `privilege`  (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('91', '0', 'malPracticeSaveButton', 'MalPracticeSaveButton', 'MALPRACTICESAVABUTTON', 'MalPracticeSaveButton', '1', '2015-08-07 00:00:00');
INSERT INTO `privilege`  (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('92', '0', 'ActivateUser', 'ActivateUser', 'ACTIVATEUSER', 'ActivateUser', '1', '2015-08-10 16:14:05');
INSERT INTO `privilege`  (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('93', '0', 'StartReplacement', 'StartReplacement', 'STARTREPLACEMENT', 'StartReplacement', '1', '2015-08-10 18:15:45');
INSERT INTO `privilege`  (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('94', '0', 'enable', 'Enable', 'ENABLE', 'Enable', '1', '2015-08-13 00:00:00');
INSERT INTO `privilege`  (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('95', '0', 'sentForApprove', 'SentForApprove', 'SENTFORAPPROVE', 'SentForApprove', '1', '2015-08-13 00:00:00');
INSERT INTO `privilege`  (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('96', '0', 'Submit', 'Submit', 'SUBMIT', 'Submit', '1', '2015-08-18 11:48:37');
INSERT INTO `privilege`  (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('97', '0', 'raiseRequest', 'RaiseRequest', 'RAISEREQUEST', 'RaiseRequest', '1', '2015-09-29 11:48:37'); 
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('98', '0', 'View Rules Criteria', 'View Rules Criteria', 'VIEWRULECRITERIA', 'View Rules Criteria', '1', '2015-10-29 11:48:37');

INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('99', '0', 'Stage Documents', 'Stage Documents', 'STAGEDOCUMENTS', 'Stage Documents', '1', '2015-10-29 11:48:37');
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('100', '0', 'Evaluate Applicant', 'Evaluate Applicant', 'EVALUATEAPPLICANT', 'Evaluate Applicant', '1', '2015-10-29 11:48:37');
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('101', '0', 'Promote To Next Stage', 'Promote To Next Stage', 'PROMOTETONEXTSTAGE', 'Promote To Next Stage', '1', '2015-10-29 11:48:37');
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('102', '0', 'Calculate Rank', 'Calculate Rank', 'CALCULATERANK', 'Calculate Rank', '1', '2015-10-29 11:58:37');
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('103', '0', 'Generate Preclosure List', 'Generate Preclosure List', 'GENERATEPRECLOSURELIST', 'Generate Preclosure List', '1', '2015-10-29 11:58:37');
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('104', '0', 'Close Stage', 'Close Stage', 'CLOSE STAGE', 'Close Stage', '1', '2015-10-31 11:58:37');
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('105', '0', 'Selection Statistic', 'Selection Statistic', 'SELECTION STATISTIC', 'Selection Statistic', '1', '2015-10-31 11:58:38');

INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('106', '0', 'Add To Approval List', 'Add To Approval List', 'ADDTOAPPROVALLIST', 'Add To Approval List', '1', '2015-10-31 11:58:39');
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('107', '0', 'View Approval List', 'View Approval List', 'VIEWAPPROVALLIST', 'View Approval List', '1', '2015-10-31 11:58:40');
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('108', '0', 'Approval Replacement', 'Approval Replacement', 'APPROVALREPLACEMENT', 'Approval Replacement', '1', '2015-10-31 11:58:40');
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('109', '0', 'Reject Replacement', 'Reject Replacement', 'REJECTREPLACEMENT', 'Reject Replacement', '1', '2015-10-31 11:58:40');
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('110', '0', 'Close Replacement', 'Close Replacement', 'CLOSEREPLACEMENT', 'Close Replacement', '1', '2015-10-31 11:58:40');
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('111', '0', 'Start Replacement', 'Start Replacement', 'STARTREPLACEMENT', 'Start Replacement', '1', '2015-10-31 11:58:40');
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('112', '0', 'Edit', 'Edit', 'EDIT', 'Edit', '1', '2015-11-02 11:48:37');
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('113', '0', 'Assign Section', 'Assign Section', 'CREATE', 'Assign Section', '1', '2015-11-06 14:56:40');
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('114', '0', 'Assign Course Variant', 'Assign Course Variant', 'ASSIGN', 'Assign Course Variant', '1', '2015-11-06 14:56:40');
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('115', '0', 'Assign Student Reading', 'Assign Student Reading', 'ASSIGN', 'Assign Student Reading', '1', '2015-11-06 14:56:40');
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('116', '0', 'Save', 'Save', 'CREATE', 'Save', '1', '2015-11-06 14:56:40');
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('117', '0', 'Assign Faculty', 'Assign Faculty', 'ASSIGNFACULTY', 'Assign Faculty', '1', '2015-11-07 14:56:40');
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('118', '0', 'Add Reading Material Information', 'Add Reading Material Information', 'ADDREADINGMATERIALINFORMATION', 'Add Reading Material Information', '1', '2015-11-07 15:06:21');
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('119', '0', 'Reading Material Details', 'Reading Material Details', 'READINGMATERIALDETAILS', 'Reading Material Details', '1', '2015-11-09 12:08:23'); 
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('120', '0', 'View Vehicle Location Status', 'View Vehicle Location Status', 'VIEWVEHICLELOCATIONSTATUS', 'View Vehicle Location Status', '1', '2015-12-04 12:08:23');
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('121', '0', 'Download Marksheets', 'Download Marksheets', 'DOWNLOADMARKSHEETS', 'DownloadMarksheets', '1', '2015-12-04 11:24:09'); 
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`)	VALUES ('122', '0', 'Advance Search', 'Advance Search', 'ADVANCESEARCHVIEW', 'Advance Search', '1', '2015-12-04 11:24:09'); 
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('123', '0', 'Send Survey', 'Send Survey', 'SENDSURVEY', 'Send Survey', '1', '2015-12-30 11:24:09');
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('124', '0', 'Force Run', 'Force Run', 'Force Run', 'Force Run', '1', '2016-12-30 11:24:09');
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('125', '0', 'Download', 'Download', 'DOWNLOAD', 'Download', '1', '2016-02-12 11:24:09');
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('126', '0', 'Student Enrollment', 'Student Enrollment', 'STUDENTENROLLMENT', 'Student Enrollment', '1', '2016-02-13 11:24:09');
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('127', '0', 'Course Enrollment', 'Course Enrollment', 'COURSEENROLLMENT', 'Course Enrollment', '1', '2016-02-13 11:24:09');
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('128', '0', 'Submit Form', 'Submit Form', 'Submit Form', 'Submit Form', '1', '2016-02-17 11:24:09');
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('129', '0', 'Export Reports', 'Export Reports', 'Export Reports', 'Export Reports', '1', '2016-02-03 14:24:09');

INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`,  `lastUpdate`) VALUES ('130', '0', 'Allot Room', 'Allot Room', 'Allot Room', 'Allot Room', '1', '2016-04-23 16:52:53');
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`,  `lastUpdate`) VALUES ('131', '0', 'Cancel Allotment', 'Cancel Allotment', 'Cancel Allotment', 'Cancel Allotment', '1', '2016-04-23 16:52:53');
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`,  `lastUpdate`) VALUES ('132', '0', 'Check In', 'Check In', 'Check In', 'CheckIn', '1', '2016-04-23 16:52:53');
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`,  `lastUpdate`) VALUES ('133', '0', 'Check Out', 'Check Out', 'Check Out', 'CheckOut', '1', '2016-04-23 16:52:53');
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('134', '0', 'printTimeTable', 'printTimeTable', 'PRINTTIMETABLE', 'printTimeTable', '1', '2016-07-01 00:00:00');
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('135', '0', 'PublishMarksheet', 'PublishMarksheet', 'PUBLISHMARSHEET', 'PublishMarksheet', '1', '2016-07-08 00:00:00');
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('136', '0', 'SetupMarksheet', 'SetupMarksheet', 'SETUPMARKSHEET', 'SetupMarksheet', '1', '2016-07-27 00:00:00');
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('137', '0', 'JobLocations', 'JobLocations', 'JOBLOCATIONS', 'JobLocations', '1', '2016-08-30 12:10:00');
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('138', '0', 'CreateLogin', 'CreateLogin', 'CREATELOGIN', 'CreateLogin', '1', '2016-09-07 00:00:00');
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`,  `lastUpdate`) VALUES ('139', '0', 'Add Application', 'Add Application', 'Add Application', 'AddApplication', '1', '2016-09-13 16:00:53');
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`,  `lastUpdate`) VALUES ('140', '0', 'Send Offer Letter', 'Send Offer Letter', 'Send Offer Letter', 'SendOfferLetter', '1', '2016-09-13 16:00:53');
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('141', '0', 'Update Offer Status', 'Update Offer Status', 'Update Offer Status', 'UpdateOfferStatus', '1', '2016-09-13 16:00:53');
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('142', '0', 'Update Joining Status', 'Update Joining Status', 'Update Joining Status', 'UpdateJoiningStatus', '1', '2016-09-13 16:00:53');
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('143', '0', 'Upload Resume', 'Upload Resume', 'Upload Resume', 'UploadResume', '1', '2016-09-13 16:00:53');
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`,  `lastUpdate`) VALUES ('144', '0', 'Promote Student', 'Promote Student', 'Promote Student', 'PromoteStudent', '1', '2016-09-23 18:00:53');
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`,  `lastUpdate`) VALUES ('145', '0', 'Profile Print', 'Profile Print', 'ProfilePrint', 'ProfilePrint', '1', '2016-11-30 15:15:53');
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`,  `lastUpdate`) VALUES ('146', '0', 'UploadDocument', 'UploadDocument', 'UploadDocument', 'UploadDocument', '1', '2016-12-16 14:30:53');
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`,  `lastUpdate`) VALUES ('147', '0', 'AssignTo', 'AssignTo', 'AssignTo', 'AssignTo', '1', '2016-12-16 13:30:53');
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`,  `lastUpdate`) VALUES ('148', '0', 'UpdateStatus', 'UpdateStatus', 'UpdateStatus', 'UpdateStatus', '1', '2016-12-16 13:30:53');
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`,  `lastUpdate`) VALUES ('149', '0', 'Enroll To', 'Enroll To', 'ENROLL_TO', 'Enroll To', '1', '2017-01-04 16:00:00');
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`,  `lastUpdate`) VALUES ('150', '0', 'ImportAttendance', 'ImportAttendance', 'IMPORTATTENDANCE', 'ImportAttendance', '1', '2017-01-20 14:20:53');
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`,  `lastUpdate`) VALUES ('151', '0', 'ImportCourseLevelAttendance', 'ImportCourseLevelAttendance', 'IMPORTCOURSELEVELATTENDANCE', 'ImportCourseLevelAttendance', '1', '2017-01-20 14:20:53');
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`,  `lastUpdate`) VALUES ('152', '0', 'Apply', 'Apply', 'APPLY', 'Apply', '1', '2017-02-09 14:20:53');
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`,  `lastUpdate`) VALUES ('153', '0', 'Add Committee', 'Add Committee', 'ADD_COMMITTEE', 'Add Committee', '1', '2017-02-09 17:00:00');
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('154', '0', 'Regenerate Hall Ticket', 'Regenerate Hall Ticket', 'REGENERATE_HALL_TICKET', 'RegenerateHallTicket', '1', '2017-03-01 20:10:00');
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('155', '0', 'Publish Hall Ticket', 'Publish Hall Ticket', 'PUBLISH_HALL_TICKET', 'PublishHallTicket', '1', '2017-03-01 20:10:00');
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('156', '0', 'Download All Hall Ticket', 'Download All Hall Ticket', 'DOWNLOAD_ALL_HALL_TICKET', 'DownloadAllHallTicket', '1', '2017-03-01 20:10:00');
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('157', '0', 'DefineRules', 'DefineRules', 'DEFINE_RULES', 'DefineRules', '1', '2017-03-02 19:20:00');
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('158', '0', 'Update Acknowledgement Status', 'Update Acknowledgement Status', 'UPDATE_ACKNOWLEDGEMENT_STATUS', 'Update Acknowledgement Status', '1', '2017-03-08 11:20:00');
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`,  `lastUpdate`) VALUES ('159', '0', 'Attendance Register', 'Attendance Register', 'ATTENDANCE_REGISTER', 'Attendance Register', '1', '2017-03-29 13:00:00');
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`,  `lastUpdate`) VALUES ('160', '0', 'Generate Attestation Form', 'Generate Attestation Form', 'GENERATE_ATTESTATION_FORM', 'Generate Attestation Form', '1', '2017-03-16 12:00:00');
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`,  `lastUpdate`) VALUES ('161', '0', 'Regenerate Attestation Form', 'Regenerate Attestation Form', 'REGENERATE_ATTESTATION_FORM', 'Regenerate Attestation Form', '1', '2017-03-16 12:00:00');
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`,  `lastUpdate`) VALUES ('162', '0', 'Download All Attestation Form', 'Download All Attestation Form', 'DOWNLOAD_ALL_ATTESTATION_FORM', 'Download All Attestation Form', '1', '2017-03-16 12:00:00');
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`,  `lastUpdate`) VALUES ('163', '0', 'Regenerate Roll List', 'Regenerate Roll List', 'REGENERATE_ROLL_LIST', 'Regenerate Roll List', '1', '2017-03-16 12:00:00');
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`,  `lastUpdate`) VALUES ('164', '0', 'Generate Roll List', 'Generate Roll List', 'GENERATE_ROLL_LIST', 'Generate Roll List', '1', '2017-03-16 12:00:00');
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`,  `lastUpdate`) VALUES ('165', '0', 'Generate Foils Report', 'Generate Foils Report', 'GENERATE_FOILS_REPORT', 'Generate Foils Report', '1', '2017-03-16 12:00:00');
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`,  `lastUpdate`) VALUES ('166', '0', 'Generate Tabulation Register', 'Generate Tabulation Register', 'GENERATE_TABULATION_REGISTOR', 'Generate Tabulation Register', '1', '2017-03-16 12:00:00');
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`,  `lastUpdate`) VALUES ('167', '0', 'Generate Report', 'Generate Report', 'GENERATE_REPORT', 'Generate Report', '1', '2017-03-16 12:00:00');
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`,  `lastUpdate`) VALUES ('168', '0', 'Mark All Present', 'Mark All Present', 'MARK_ALL_PRESENT', 'Mark All Present', '1', '2017-03-16 12:00:00');
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`,  `lastUpdate`) VALUES ('169', '0', 'Mark All Absent', 'Mark All Absent', 'MARK_ALL_ABSENT', 'Mark All Absent', '1', '2017-03-16 12:00:00');
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('203', '0', 'Manage Minutes', 'Manage Minutes', 'MANAGE_MINUTES', 'Manage Minutes', '1', '2017-05-26 10:50:00');
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('204', '0', 'Print Attendance Sheet', 'Print Attendance Sheet', 'PRINT_ATTENDANCE_SHEET', 'Print Attendance Sheet', '1', '2017-05-26 10:50:00');
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('205', '0', 'Print Minute', 'Print Minute', 'PRINT_MINUTE', 'Print Minute', '1', '2017-05-26 10:50:00');
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('209', '0', 'Add Meeting', 'Add Meeting', 'ADD_MEETING', 'Add Meeting', '1', '2017-07-06 15:35:00');
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('210', '0', 'Enroll', 'Enroll', 'Enroll', 'Enroll', '1', '2017-07-10 17:45:00');
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('211', '0', 'UnEnroll', 'UnEnroll', 'UnEnroll', 'UnEnroll', '1', '2017-07-10 17:45:00');
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('212', '0', 'Generate Grade Roster Report', 'Generate Grade Roster Report', 'GENERATE_GRADE_ROSTER_REPORT', 'Generate Grade Roster Report', '1', '2017-07-25 16:10:00');
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('213', '0', 'Generate Course Roster Report', 'Generate Course Roster Report', 'GENERATE_COURSE_ROSTER_REPORT', 'Generate Course Roster Report', '1', '2017-07-25 16:10:00');
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('214', '0', 'Assign Work Calendar', 'Assign Work Calendar', 'ASSIGN_WORK_CALENDAR', 'Assign Work Calendar', '1', '2017-07-06 15:35:00');
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('221', '0', 'Manage Addresses', 'Manage Addresses', 'MANAGE_ADDRESSES', 'Manage Addresses', '1', '2017-09-01 16:00:00');
INSERT INTO `privilege` (`id`,`version`,`description`,`displayCode`,`code`,`privilegeName`,`lastUpdatedBy`,`lastUpdate`) VALUES (222, '0', 'Import Bulk Application New', 'Import Bulk Application New', 'IMPORT_BULK_APPLICATION_NEW', 'Import Bulk Application New', '1', '2017-10-24 14:20:00');
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('228', '0', 'Import Bulk Assessment Events', 'Import Bulk Assessment Events', 'IMPORT_BULK_ASSESSMENT_EVENTS', 'Import Bulk Assessment Events', '1', '2017-11-06 16:40:00');

INSERT INTO `privilege` (`id`,`version`,`description`,`displayCode`,`code`,`privilegeName`,`lastUpdatedBy`,`lastUpdate`) VALUES (222, '0', 'Import Bulk Application New', 'Import Bulk Application New', 'IMPORT_BULK_APPLICATION_NEW', 'Import Bulk Application New', '1', '2017-10-24 14:20:00');
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('223', '0', 'View All Enquiries', 'View All Enquiries', 'VIEW_ALL_ENQUIRIES', 'View All Enquiries', '1', '2017-10-25 17:20:00');
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('224', '0', 'View My Enquiries', 'View My Enquiries', 'VIEW_MY_ENQUIRIES', 'View My Enquiries', '1', '2017-10-25 17:20:00');
INSERT INTO  `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('237', '0', 'Apply Changes', 'Apply Changes', 'APPLYCHANGES', 'Apply Changes', '1', '2017-11-30 00:00:00');
INSERT INTO  `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('238', '0', 'Criteria Based Grade', 'criteriaBasedGrade', 'CRITERIA_BASED_GRADE', 'Criteria Based Grade', '1', '2017-11-30 00:00:00');
INSERT INTO  `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('239', '0', 'Special Grade', 'Special Grade', 'SPECIALGRADE', 'Special Grade', '1', '2017-11-30 00:00:00');
INSERT INTO `privilege` (`id`,`version`,`description`,`displayCode`,`code`,`privilegeName`,`lastUpdatedBy`,`lastUpdate`) VALUES (229, '0', 'Import Bulk Student Past History', 'Import Bulk Student Past History', 'IMPORT_EDUCATION_HISTORY', 'Import Bulk Student Past History', '1', '2017-11-09 14:20:00');
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('230', '0', 'Change Enrollment Date', 'Change Enrollment Date', 'CHANGE_ENROLLMENT_DATE', 'Change Enrollment Date', '1', '2017-11-10 13:30:00');
INSERT INTO `privilege` (`id`,`version`,`description`,`displayCode`,`code`,`privilegeName`,`lastUpdatedBy`,`lastUpdate`) VALUES (231, '0', 'Import Facility and Master', 'Import Facility and Master', 'IMPORT_F_N_M', 'Import Facility and Master', '1', '2017-11-11 14:20:00');
INSERT INTO `privilege` (`id`,`version`,`description`,`displayCode`,`code`,`privilegeName`,`lastUpdatedBy`,`lastUpdate`) VALUES (232,'0', 'Bulk Document Download', 'Bulk Document Download', 'BULK_DOCUMENT_DOWNLOAD', 'Bulk Document Download', '1', '2017-11-17 14:06:00');
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('233', '0', 'Accept Offer', 'Accept Offer', 'ACCEPT_OFFER', 'Accept Offer', '1', '2017-11-22 14:25:00');
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('234', '0', 'Decline Offer', 'Decline Offer', 'DECLINE_OFFER', 'Decline Offer', '1', '2017-11-22 14:25:00');
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('235','0', 'Bulk Application Document Download', 'Bulk Application Document Download', 'BULK_APPLICATION_DOCUMENT_DOWNLOAD', 'Bulk Application Document Download', '1', '2017-11-21 18:15:00');
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('243', '0', 'Calculate Average', 'Calculate Average', 'CALCULATE_AVERAGE', 'Calculate Average', '1', '2018-01-13 14:20:53');
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('244', '0', 'Program Batch Section', 'Program Batch Section', 'PROGRAM_BATCH_SECTION', 'Program Batch Section', '1', '2018-01-15 14:20:53');
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('245', '0', 'Course Section', 'Course Section', 'COURSE_SECTION', 'Course Section', '1', '2018-01-15 14:20:53');
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('246', '0', 'Section Group', 'Section Group', 'SECTION_GROUP', 'Section Group', '1', '2018-01-15 14:20:53');
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('247', '0', 'Import Assign Remark', 'Import Assign Remark', 'IMPORT_ASSIGN_REMARK', 'Import Assign Remark', '1', '2018-02-02 14:34:53');
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('251', '0', 'Generate Timesheet', 'Generate Timesheet', 'GENERATE_TIMESHEET', 'Generate Timesheet', '1', '2018-02-16 15:44:00');
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('252', '0', 'Approve Timesheet', 'Approve Timesheet', 'APPROVE_TIMESHEET', 'Approve Timesheet', '1', '2018-02-16 15:44:00');
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('253', '0', 'Bulk Student Document Download', 'Bulk Student Document Download', 'BULK_STUDENT_DOCUMENT_DOWNLOAD', 'Bulk Student Document Download', '1', '2018-02-26 14:15:00');
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('254', '0', 'Bulk Employee Document Download', 'Bulk Employee Document Download', 'BULK_EMPLOYEE_DOCUMENT_DOWNLOAD', 'Bulk Employee Document Download', '1', '2018-02-26 14:15:00');
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('258', '0', 'mark attendance', 'Mark Attendance', 'MARK_ATTENDANCE_BTN', 'Mark Attendance Btn', '1', '2018-02-26 14:15:00');
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('259', '0', 'Link', 'Link', 'LINK', 'Link', '1', '2018-04-04 11:45:00');
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('272', '0', 'Define Program Term', 'Define Program Term', 'DEFINE_PROGRAM_TERM', 'Define Program Term', '1', '2018-05-27 16:20:26');
INSERT INTO `privilege`  (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('325', '0', 'licenceHistory', 'Licence History', 'LICENCEHISTORY', 'Licence History', '1', '2018-12-08 16:20:00');
INSERT INTO `privilege` (`id`,`version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`) VALUES (327,'0', 'Import Bulk User Update', 'Import Bulk User Update', 'IMPORT_BULK_USER_UPDATE', 'Import Bulk User Update', '1');
-- Update Privileges Display Name for Role Privileges Screen
/*UPDATE `privilege` SET `description`='Assign Application ID', `displayCode`='Assign Application ID', `privilegeName`='Assign Application ID' WHERE `id`='42';
UPDATE `privilege` SET `description`='Configure Group', `displayCode`='Configure Group', `privilegeName`='Configure Group' WHERE `id`='38';
UPDATE `privilege` SET `description`='Copy Configuration Combination', `displayCode`='Copy Configuration Combination', `privilegeName`='Copy Configuration Combination' WHERE `id`='40';
UPDATE `privilege` SET `description`='Collect Payment', `displayCode`='Collect Payment', `privilegeName`='Collect Payment' WHERE `id`='43';
UPDATE `privilege` SET `description`='Save Reordering', `displayCode`='Save Reordering', `privilegeName`='Save Reordering' WHERE `id`='69';
UPDATE `privilege` SET `description`='applyTo', `displayCode`='Apply To', `privilegeName`='Apply To' WHERE `id`='16';
UPDATE `privilege` SET `description`='Upload Document', `displayCode`='Upload Document', `privilegeName`='Upload Document' WHERE `id`='35';*/

-- Entity Setting Seed Data
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('260', '0', 'Manage Event Status', 'Manage Event Status', 'MANAGE_EVENT_STATUS', 'Manage Event Status', '1', '2018-04-04 16:00:00');
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('261', '0', 'Subject Level Remark Report', 'Subject Level Remark Report', 'SUBJECT_LEVEL_REMARK_REPORT', 'Subject Level Remark Report', '1', '2018-04-11 14:20:53');
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('263', '0', 'Anonymous Assessment Event ', 'Anonymous Assessment Event', 'ANONYMOUS_ASSESSMENT_EVENT', 'Anonymous Assessment Event', '1', '2018-05-01 14:46:00');
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('266', '0', 'DeleteEnroll', 'DeleteEnroll', 'DeleteEnroll', 'DeleteEnroll', '1', '2018-05-12 10:50:00');
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('267', '0', 'PeriodDetails', 'PeriodDetails', 'PeriodDetails', 'PeriodDetails', '1', '2018-05-12 10:50:00');
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('268', '0', 'Student', 'Student', 'STUDENT', 'Student', '1', '2018-05-18 17:20:00');
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('269', '0', 'Faculty', 'Faculty', 'FACULTY', 'Faculty', '1', '2018-05-18 17:20:00');
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('270', '0', 'Room', 'Room', 'ROOM', 'Room', '1', '2018-05-18 17:20:00');
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('271', '0', 'Reset', 'Reset', 'RESET', 'Reset', '1', '2018-06-01 14:50:00');
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('272', '0', 'Define Program Term', 'Define Program Term', 'DEFINE_PROGRAM_TERM', 'Define Program Term', '1', '2018-05-27 16:20:26');
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('273', '0', 'Request Pending For', 'Request Pending For', 'REQUEST_PENDING_FOR', 'Request Pending For', '1', '2018-06-04 15:50:00');
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('274', '0', 'For Other Employee', 'For Other Employee', 'FOR_OTHER_EMPLOYEE', 'For Other Employee', '1', '2018-06-05 15:50:00');
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('275', '0', 'Map Program Period', 'Map Program Period', 'MAP_PROGRAM_PERIOD', 'Map Program Period', '1', '2018-06-07 15:50:00');
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('276', '0', 'Map Course Variants', 'Map Course Variants', 'MAP_COURSE_VARIANTS', 'Map Course Variants', '1', '2018-06-07 15:50:00');
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('277', '0', 'Unmap Program Period', 'Unmap Program Period', 'UNMAP_PROGRAM_PERIOD', 'Unmap Program Period', '1', '2018-06-07 15:50:00');
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('278', '0', 'Unmap Course Variants', 'Unmap Course Variants', 'UNMAP_COURSE_VARIANTS', 'Unmap Course Variants', '1', '2018-06-07 15:50:00');
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('279', '0', 'Grade Average Report', 'Grade Average Report', 'GRADE_AVERAGE_REPORT', 'Grade Average Report', '1', '2018-06-13 15:50:00');
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('280', '0', 'Add Students', 'Add Students', 'ADD_STUDENTS', 'Add Students', '1', SYSDATE());
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('283', '0', 'Cancel', 'Cancel', 'CANCEL', 'Cancel', 1, '2018-07-06 13:57:00');
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('284', '0', 'Export To PNG', 'Export To PNG', 'EXPORT_TO_PNG', 'Export To PNG', '1', SYSDATE());
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('286', '0', 'Program Wise', 'Program Wise', 'PROGRAM_WISE', 'Program Wise', '1', SYSDATE());
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('287', '0', 'Course Wise', 'Course Wise', 'COURSE_WISE', 'Course Wise', '1', SYSDATE());
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('288', '0', 'Session Wise', 'Session Wise', 'SESSION_WISE', 'Session Wise', '1', SYSDATE());
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('289', '0', 'Set As Current Period', 'Set As Current Period', 'SET_AS_CURRENT_PERIOD', 'Set As Current Period', '1', SYSDATE());
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('291', '0', 'Set Default Marks', 'Set Default Marks', 'SET_DEFAULT_MARKS', 'Set Default Marks', '1', SYSDATE());
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('292', '0', 'Set Default Grade', 'Set Default Grade', 'SET_DEFAULT_GRADE', 'Set Default Grade', '1', SYSDATE());
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('293', '0', 'DeEnroll', 'DeEnroll', 'DEENROLL', 'DeEnroll', '1', SYSDATE());
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('290', '0', 'Publish', 'Publish', 'PUBLISH', 'Publish', '1', SYSDATE());
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('294', '0', 'Update Attendance', 'Update Attendance', 'UPDATE_ATTENDANCE', 'UpdateAttendance', '1', SYSDATE());
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('295', '0', 'Manage Event Status Pending', 'Manage Event Status Pending', 'MANAGE_EVENT_STATUS_PENDING', 'Manage Event Status Pending', '1', SYSDATE());
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('296', '0', 'Open For Mark Entry', 'Open For Mark Entry', 'OPEN_FOR_MARK_ENTRY', 'Open For Mark Entry', '1', SYSDATE());
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('297', '0', 'Close Mark Entry', 'Close Mark Entry', 'CLOSE_MARK_ENTRY', 'Close Mark Entry', '1', SYSDATE());
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('298', '0', 'Manage Event Status Result Declared', 'Manage Event Status Result Declared', 'MANAGE_EVENT_STATUS_RESULT_DECLARED', 'Manage Event Status Result Declared', '1', SYSDATE());
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('299', '0', 'Manage Hierarchy Status Pending', 'Manage Hierarchy Status Pending', 'MANAGE_HIERARCHY_STATUS_PENDING', 'Manage Hierarchy Status Pending', '1', SYSDATE());
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('300', '0', 'Manage Hierarchy Status Result Declared', 'Manage Hierarchy Status Result Declared', 'MANAGE_HIERARCHY_STATUS_RESULT_DECLARED', 'Manage Hierarchy Status Result Declared', '1', SYSDATE());
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('301', '0', 'Export Grade Book ', 'Export Grade Book', 'EXPORT_GRADE_BOOK', 'Export Grade Book', '1', SYSDATE());
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('304', '0', 'Adhoc Message', 'Adhoc Message', 'ADHOC_MESSAGE', 'Adhoc Message', '1', SYSDATE());
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('305', '0', 'Message Template', 'Message Template', 'MESSAGE_TEMPLATE', 'Message Template', '1', SYSDATE());
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('308', '0', 'Offline Payment', 'Offline Payment', 'OFFLINE_PAYMENT', 'Offline Payment', '1', SYSDATE());
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('312', '0', 'Student Photo Report', 'Student Photo Report', 'STUDENT_PHOTO_REPORT', 'Student Photo Report', '1', SYSDATE());
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('314', '0', 'Change Specialization', 'Change Specialization', 'CHANGE_SPECIALIZATION', 'Change Specialization', '1', SYSDATE());
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('324', '0', 'View Album Details', 'View Album Details', 'VIEW_ALBUM_DETAILS', 'View Album Details', '1', SYSDATE());
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('332', '0', 'Recalculate Result', 'Recalculate Result', 'RECALCULATE_RESULT', 'Recalculate Result', '1', '2019-01-15 15:30:23');
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('338', 0, 'zscore', 'zscore', 'ZSCORE', 'zscore', 1, '2018-01-12 14:46:00');
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('339', '0', 'Course Group Associated', 'Course Group Associated', 'COURSE_GROUP_ASSOCIATED', 'Course Group Associated', '1', SYSDATE());
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('340', '0', 'Course Component Associated', 'Course Component Associated', 'COURSE_COMPONENT_ASSOCIATED', 'Course Component Associated', '1', SYSDATE());
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('341', '0', 'Reading Material Associated', 'Reading Material Associated', 'READING_MATERIAL_ASSOCIATED', 'Reading Material Associated', '1', SYSDATE());
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('342', '0', 'Course Variants Associated', 'Course Variants Associated', 'COURSE_VARIANTS_ASSOCIATED', 'Course Variants Associated', '1', SYSDATE());
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('343', '0', 'Topics Created', 'Topics Created', 'TOPICS_CREATED', 'Topics Created', '1', SYSDATE());
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('344', '0', 'Course Assessment', 'Course Assessment', 'COURSE_ASSESSMENT', 'Course Assessment', '1', SYSDATE());
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('360', '0', 'Import ASC Timetable', 'Import ASC Timetable', 'IMPORT_ASC_TIMETABLE', 'Import ASC Timetable', '1', SYSDATE());
INSERT INTO `privilege` (`id`, `version`, `description`, `displayCode`, `code`, `privilegeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('380', '0', 'Bulk Enrol', 'Bulk Enrol', 'BULK_ENROL', 'Bulk Enrol', '1', SYSDATE());

insert  into `entity_setting`(`id`,`fieldDataTypeCode`,`fieldLabel`,`fieldCode`,`mandatory`,`displayOrder`,`typeCode`,`defaultValue`,`lastUpdate`,`lastUpdatedBy`,`version`) values (1,'IFL','Import File Location','IFL','',1,'IFL',NULL,'2014-03-04 00:00:00',1,0);
insert  into `entity_setting`(`id`,`fieldDataTypeCode`,`fieldLabel`,`fieldCode`,`mandatory`,`displayOrder`,`typeCode`,`defaultValue`,`lastUpdate`,`lastUpdatedBy`,`version`) values (2,'EFL','Export File Location','EFL','',2,'EFL',NULL,'2014-03-04 00:00:00',1,0);
insert  into `entity_setting`(`id`,`fieldDataTypeCode`,`fieldLabel`,`fieldCode`,`mandatory`,`displayOrder`,`typeCode`,`defaultValue`,`lastUpdate`,`lastUpdatedBy`,`version`) values (3,'COUNTRY','COUNTRY','CNT','',3,'CNT',NULL,'2014-03-04 00:00:00',1,0);
insert  into `entity_setting`(`id`,`fieldDataTypeCode`,`fieldLabel`,`fieldCode`,`mandatory`,`displayOrder`,`typeCode`,`defaultValue`,`lastUpdate`,`lastUpdatedBy`,`version`) values (4,'DCN','Data Change Notification via Email','DCN','',4,'DNE',NULL,'2014-03-04 00:00:00',1,0);
insert  into `entity_setting`(`id`,`fieldDataTypeCode`,`fieldLabel`,`fieldCode`,`mandatory`,`displayOrder`,`typeCode`,`defaultValue`,`lastUpdate`,`lastUpdatedBy`,`version`) values (5,'DF','DF','DF','',5,'DF',NULL,'2014-03-06 00:00:00',1,0);
insert  into `entity_setting`(`id`,`fieldDataTypeCode`,`fieldLabel`,`fieldCode`,`mandatory`,`displayOrder`,`typeCode`,`defaultValue`,`lastUpdate`,`lastUpdatedBy`,`version`) values (6,'TF','TF','TF','',6,'TF',NULL,'2014-03-06 00:00:00',1,0);
insert  into `entity_setting`(`id`,`fieldDataTypeCode`,`fieldLabel`,`fieldCode`,`mandatory`,`displayOrder`,`typeCode`,`defaultValue`,`lastUpdate`,`lastUpdatedBy`,`version`) values (7,'CF','CF','CF','',7,'CF',NULL,'2014-03-06 00:00:00',1,0);
insert  into `entity_setting`(`id`,`fieldDataTypeCode`,`fieldLabel`,`fieldCode`,`mandatory`,`displayOrder`,`typeCode`,`defaultValue`,`lastUpdate`,`lastUpdatedBy`,`version`) values (8,'DCNS','Data Change Notification via SMS','DCN','',8,'DNS',NULL,'2014-04-14 00:00:00',1,0);
insert  into `entity_setting`(`id`,`fieldDataTypeCode`,`fieldLabel`,`fieldCode`,`mandatory`,`displayOrder`,`typeCode`,`defaultValue`,`lastUpdate`,`lastUpdatedBy`,`version`) values (9,'STI','Show Thumbnail Image','STI','',9,'STI',NULL,'2014-04-28 12:43:28',1,0);

-- Service Request Seed Data

insert  into `request_status`(`serviceRequestStage`,`id`,`itemCode`,`itemValue`,`lastUpdate`,`lastUpdatedBy`) values ('INITIATED',1,'Submitted','Submitted','2014-08-28 12:20:00',1),('INITIATED',2,'Assigned','Assigned','2014-08-28 12:20:01',1),('PRECLOSURE',3,'Escalated','Escalated','2014-11-04 13:19:32',1),('PRECLOSURE',4,'Approved','Approved','2014-08-28 12:21:13',1),('PRECLOSURE',5,'Rejected','Rejected','2014-08-28 12:26:07',1),('CLOSURE',6,'Closed','Closed','2014-08-28 12:26:33',1),('CLOSED',7,'Withdrawn','Withdrawn','2015-01-05 18:33:28',1);
insert  into `request_types`(`id`,`serviceRequestGroup`,`whetherDeleted`,`requestTypeCode`,`requestTypeName`,`lastUpdatedBy`,`lastUpdate`,`type`,`feeRelatedCategory`) values (1,'TRANSFER','\0','PT','Program Transfer',1,'2014-08-01 07:13:42','COMMON',NULL),(2,'TRANSFER','\0','CT','Course Transfer',1,'2014-08-01 07:13:42','COMMON',NULL),(3,'TRANSFER','\0','ST','Section Transfer',1,'2014-08-01 07:13:42','COMMON',NULL),(4,'TRANSFER','\0','SR','Scholarship Request',1,'2014-08-01 07:13:42','COMMON',NULL),(5,'TRANSFER','\0','WFC','Withdraw From Course',1,'2014-08-01 07:13:42','COMMON',NULL),(6,'TRANSFER','\0','WFPO','Withdraw From Program',1,'2014-09-11 07:25:49','COMMON',NULL),(14,'TRANSFER','\0','SWS','Subscribe/Withdrawal Service',1,'2014-08-26 07:22:11','COMMON',NULL),(15,'TRANSFER','\0','LR','Leave Request',1,'2014-08-26 07:22:11','COMMON',NULL),(16,'EXAM_RELATED','\0','COEDE','Change Of Exam Date',1,'2014-11-07 11:42:50','COMMON',NULL),(17,'EXAM_RELATED','\0','COCE','Change Of Center',1,'2014-08-26 07:22:11','COMMON',NULL),(18,'EXAM_RELATED','\0','ROEPE','Revaluation Of Exam Paper',1,'2014-08-26 07:22:11','COMMON',NULL),(19,'EXAM_RELATED','\0','WOEE','Withdrawal Of Exam',1,'2014-08-26 07:22:11','COMMON',NULL),(20,'EXAM_RELATED','\0','LOAE','Lack Of Attendance ',1,'2014-11-07 11:42:27','COMMON',NULL),(21,'EXAM_RELATED','\0','LOOCE','Lack Of Other Criteria',1,'2014-08-26 07:22:11','COMMON',NULL),(22,'EXAM_RELATED','\0','ROREE','Request Of Re-Examination',1,'2014-11-07 11:43:03','COMMON',NULL),(23,'EXAM_RELATED','\0','ELRE','Exam Leave Request ',1,'2014-11-07 11:42:35','COMMON',NULL),(24,'PERSONAL_DATA_CHANGE','\0','SHR','Stake Holder Request',1,'2014-11-07 11:42:42','COMMON',NULL),(25,'TRANSFER','\0','TREO','Termination Request',1,'2014-08-26 12:53:21','COMMON',NULL),(26,'TRANSFER','\0','TRAO','Transfer Request',1,'2014-08-26 12:53:21','COMMON',NULL),(27,'TRANSFER','\0','WFPO','Withdrawal From Program',1,'2014-08-26 12:53:21','COMMON',NULL),(36,'TRANSFER','\0','INS','Fee Installment',1,'2014-08-06 15:41:21','FEE_RELATED_REQUEST_TYPE','INSTALLMENT'),(37,'TRANSFER','\0','CONSSN','Fee Concession',1,'2014-11-07 11:43:40','FEE_RELATED_REQUEST_TYPE','FEE_CONCESSION'),(38,'PERSONAL_DATA_CHANGE','\0','PDCPDC','Personal Detail Change',1,'2014-09-03 08:59:34','COMMON',NULL),(39,'PERSONAL_DATA_CHANGE','\0','MHPDC','Medical History',1,'2014-09-03 09:00:52','COMMON',NULL),(40,'PERSONAL_DATA_CHANGE','\0','WEPDC','Work Experience',1,'2014-09-24 09:06:56','COMMON',NULL),(41,'PERSONAL_DATA_CHANGE','\0','PD','Previous Education Detail',1,'2014-09-18 09:09:12','COMMON',NULL),(42,'PERSONAL_DATA_CHANGE','\0','ECPDC','Extra Curricular Detail',1,'2014-09-05 10:00:07','COMMON',NULL),(43,'PERSONAL_DATA_CHANGE','\0','VDPDC','Vaccination Detail',1,'2014-09-05 10:00:07','COMMON',NULL),(44,'PERSONAL_DATA_CHANGE','\0','SBDPDC','Sibling Detail',1,'2014-09-05 10:00:07','COMMON',NULL),(45,'TRANSFER','\0','DR','Debarment Request',1,'2014-09-23 12:00:19','COMMON',NULL),(46,'PERSONAL_DATA_CHANGE','\0','VDPDC','Vaccination Detail',1,'2014-11-07 11:37:09','COMMON',NULL);


insert  into `request_type_categories`(`id`,`serviceRequestCategory`,`whetherDeleted`,`lastUpdatedBy`,`lastUpdate`,`requestTypeId`) values (1,'STUDENT_REQUEST','\0',1,'2014-08-05 07:41:48',1),(2,'STUDENT_REQUEST','\0',1,'2014-08-05 07:41:48',2),(3,'STUDENT_REQUEST','\0',1,'2014-08-05 07:41:48',3),(4,'STUDENT_REQUEST','\0',1,'2014-08-05 07:41:48',4),(5,'STUDENT_REQUEST','\0',1,'2014-08-05 07:41:48',5),(6,'STUDENT_REQUEST','\0',1,'2014-08-05 07:41:48',6),(14,'STUDENT_REQUEST','\0',1,'2014-08-05 07:41:48',14),(15,'STUDENT_REQUEST','\0',1,'2014-08-05 07:41:48',15),(16,'FACULTY_REQUEST','\0',1,'2014-08-18 10:09:46',3),(17,'FACULTY_REQUEST','\0',1,'2014-08-18 10:09:46',14),(18,'FACULTY_REQUEST','\0',1,'2014-08-18 10:09:46',15),(19,'FACULTY_REQUEST','\0',1,'2014-08-18 10:09:46',38),(20,'STUDENT_REQUEST','\0',1,'2014-08-18 10:09:46',24),(21,'STUDENT_REQUEST','\0',1,'2014-08-18 10:09:46',23),(22,'TERMINATION_REQUEST','\0',1,'2014-08-26 12:57:40',25),(23,'TRANSFER_REQUEST','\0',1,'2014-08-19 12:57:49',26),(24,'WITHDRAWAL_REQUEST','\0',1,'2014-08-18 12:58:32',27),(25,'PUBLIC_USER_REQUEST','\0',1,'2014-08-26 13:01:40',16),(26,'PUBLIC_USER_REQUEST','\0',1,'2014-08-26 13:01:40',17),(27,'PUBLIC_USER_REQUEST','\0',1,'2014-08-26 13:01:40',18),(28,'PUBLIC_USER_REQUEST','\0',1,'2014-08-26 13:01:40',19),(29,'PUBLIC_USER_REQUEST','\0',1,'2014-08-26 13:01:40',20),(30,'PUBLIC_USER_REQUEST','\0',1,'2014-08-26 13:01:40',21),(31,'PUBLIC_USER_REQUEST','\0',1,'2014-08-26 13:01:40',22),(32,'STUDENT_REQUEST','\0',1,'2014-08-18 10:09:46',16),(33,'STUDENT_REQUEST','\0',1,'2014-08-18 10:09:46',17),(34,'STUDENT_REQUEST','\0',1,'2014-08-18 10:09:46',18),(35,'STUDENT_REQUEST','\0',1,'2014-08-18 10:09:46',19),(36,'STUDENT_REQUEST','\0',1,'2014-08-18 10:09:46',20),(37,'STUDENT_REQUEST','\0',1,'2014-08-18 10:09:46',21),(38,'STUDENT_REQUEST','\0',1,'2014-08-18 10:09:46',22),(48,'STUDENT_REQUEST','\0',1,'2014-09-30 09:58:52',38),(49,'STUDENT_REQUEST','\0',1,'2014-09-30 09:58:52',39),(50,'STUDENT_REQUEST','\0',1,'2014-09-30 09:58:52',40),(51,'STUDENT_REQUEST','\0',1,'2014-09-30 09:58:52',41),(52,'STUDENT_REQUEST','\0',1,'2014-09-30 09:58:52',42),(53,'STUDENT_REQUEST','\0',1,'2014-09-30 09:58:52',43),(54,'STUDENT_REQUEST','\0',1,'2014-09-30 09:58:52',44),(55,'DEBRAMENT_REQUEST','\0',1,'2014-09-25 06:14:14',45),(57,'STUDENT_REQUEST','\0',1,'2014-09-30 09:58:52',49);


-- Month Seed Data
insert  into `months`(`id`,`monthName`,`monthSequence`,`lastUpdatedBy`,`lastUpdate`) values (1,'JANUARY',1,1,'2014-08-22 18:18:21');
insert  into `months`(`id`,`monthName`,`monthSequence`,`lastUpdatedBy`,`lastUpdate`) values (2,'FEBRUARY',2,1,'2014-08-22 18:18:21');
insert  into `months`(`id`,`monthName`,`monthSequence`,`lastUpdatedBy`,`lastUpdate`) values (3,'MARCH',3,1,'2014-08-22 18:18:21');
insert  into `months`(`id`,`monthName`,`monthSequence`,`lastUpdatedBy`,`lastUpdate`) values (4,'APRIL',4,1,'2014-08-22 18:18:21');
insert  into `months`(`id`,`monthName`,`monthSequence`,`lastUpdatedBy`,`lastUpdate`) values (5,'MAY',5,1,'2014-08-22 18:18:21');
insert  into `months`(`id`,`monthName`,`monthSequence`,`lastUpdatedBy`,`lastUpdate`) values (6,'JUNE',6,1,'2014-08-22 18:18:21');
insert  into `months`(`id`,`monthName`,`monthSequence`,`lastUpdatedBy`,`lastUpdate`) values (7,'JULY',7,1,'2014-08-22 18:18:21');
insert  into `months`(`id`,`monthName`,`monthSequence`,`lastUpdatedBy`,`lastUpdate`) values (8,'AUGUST',8,1,'2014-08-22 18:18:21');
insert  into `months`(`id`,`monthName`,`monthSequence`,`lastUpdatedBy`,`lastUpdate`) values (9,'SEPTEMBER',9,1,'2014-08-22 18:18:21');
insert  into `months`(`id`,`monthName`,`monthSequence`,`lastUpdatedBy`,`lastUpdate`) values (10,'OCTOBER',10,1,'2014-08-22 18:18:21');
insert  into `months`(`id`,`monthName`,`monthSequence`,`lastUpdatedBy`,`lastUpdate`) values (11,'NOVEMBER',11,1,'2014-08-22 18:18:21');
insert  into `months`(`id`,`monthName`,`monthSequence`,`lastUpdatedBy`,`lastUpdate`) values (12,'DECEMBER',12,1,'2014-08-22 18:18:21');

-- Custom Field Seed Data
 insert  into `entity_type`(`id`,`entityName`,`displayCode`,`whetherConfigured`,`entityCode`) values (1,'User Custom Fields','user_cf_data','','');
 insert  into `entity_type`(`id`,`entityName`,`displayCode`,`whetherConfigured`,`entityCode`) values (2,'Enquiry Raise CF Data','enquiry_cf_data','','');
 insert  into `entity_type`(`id`,`entityName`,`displayCode`,`whetherConfigured`,`entityCode`) values (3,'Program Custom Field','program_cf_data','','');
 insert  into `entity_type`(`id`,`entityName`,`displayCode`,`whetherConfigured`,`entityCode`) values (4,'Campaign Custom Field','campaign_cf_data','','');
 insert  into `entity_type`(`id`,`entityName`,`displayCode`,`whetherConfigured`,`entityCode`) values (5,'Exam Detail Custom Field','enquiry_exam_detail_cf_data','','');
 insert  into `entity_type`(`id`,`entityName`,`displayCode`,`whetherConfigured`,`entityCode`) values (6,'Course Reading Custom Field','course_reading_cf_data','','');
 insert  into `entity_type`(`id`,`entityName`,`displayCode`,`whetherConfigured`,`entityCode`) values (7,'Study Distribution Custom Field','distribution_list_cf_data','','');
 insert  into `entity_type`(`id`,`entityName`,`displayCode`,`whetherConfigured`,`entityCode`) values (8,'Batch Custom Field','batches_cf_data','','');
 insert  into `entity_type`(`id`,`entityName`,`displayCode`,`whetherConfigured`,`entityCode`) values (9,'Seat Type Custom Field','program_batch_seat_type_cf_data','','');
 insert  into `entity_type`(`id`,`entityName`,`displayCode`,`whetherConfigured`,`entityCode`) values (10,'Program Batch Period Custom Field','program_batch_period_cf_data','','');
 insert  into `entity_type`(`id`,`entityName`,`displayCode`,`whetherConfigured`,`entityCode`) values (11,'Course Component Custom Field','course_components_cf_data','','');
 insert  into `entity_type`(`id`,`entityName`,`displayCode`,`whetherConfigured`,`entityCode`) values (12,'Home Work Assignment Detail Custom Field','home_work_assignment_cf_data','','');
 insert  into `entity_type`(`id`,`entityName`,`displayCode`,`whetherConfigured`,`entityCode`) values (13,'Period Break Custom Field','prog_period_break_config_cf_data','','');
 insert  into `entity_type`(`id`,`entityName`,`displayCode`,`whetherConfigured`,`entityCode`) values (14,'Batch Related Course Custom Field','program_related_course_cf_data','','');
 insert  into `entity_type`(`id`,`entityName`,`displayCode`,`whetherConfigured`,`entityCode`) values (15,'Fee Plan Cutsom Field','fee_plan_cf_data','','');
 insert  into `entity_type`(`id`,`entityName`,`displayCode`,`whetherConfigured`,`entityCode`) values (16,'Fee Plan Sequence Custom Field','fee_plan_rules_cf_data','','');
 insert  into `entity_type`(`id`,`entityName`,`displayCode`,`whetherConfigured`,`entityCode`) values (17,'Configure Fee Head Custom Field','fee_stage_head_config_cf_data','','');
 insert  into `entity_type`(`id`,`entityName`,`displayCode`,`whetherConfigured`,`entityCode`) values (18,'Course Topic Custom Field','course_topic_cf_data','','');
 insert  into `entity_type`(`id`,`entityName`,`displayCode`,`whetherConfigured`,`entityCode`) values (19,'Course Group Custom Field','course_group_cf_data','','');
 insert  into `entity_type`(`id`,`entityName`,`displayCode`,`whetherConfigured`,`entityCode`) values (20,'Application Form Sale Custom Field','application_form_cf_data','','');
 insert  into `entity_type`(`id`,`entityName`,`displayCode`,`whetherConfigured`,`entityCode`) values (21,'Section Custom Field','section_cf_data','','');
 insert  into `entity_type`(`id`,`entityName`,`displayCode`,`whetherConfigured`,`entityCode`) values (22,'Admission Requirment Custom Field','admission_enq_details_cf_data','','');


-- Moved from "Need To BE Verified.sql" --

-- Resource Types available for booking
insert  into `resource_types`(`id`,`version`,`resourceGroup`,`code`,`typeName`,`lastUpdatedBy`,`lastUpdate`) values (1,0,'FACILITY','BLD','Building',1,'2014-05-19 15:24:31');
insert  into `resource_types`(`id`,`version`,`resourceGroup`,`code`,`typeName`,`lastUpdatedBy`,`lastUpdate`) values (2,0,'EQUIPMENT','Portable','Portable',1,'2014-05-19 15:17:34');
insert  into `resource_types`(`id`,`version`,`resourceGroup`,`code`,`typeName`,`lastUpdatedBy`,`lastUpdate`) values (3,0,'EQUIPMENT','ELEC','Electric Equip',1,'2014-05-19 15:21:01');
insert  into `resource_types`(`id`,`version`,`resourceGroup`,`code`,`typeName`,`lastUpdatedBy`,`lastUpdate`) values (4,1,'FACILITY','HALL','Hall',1,'2014-05-19 15:19:51');
insert  into `resource_types`(`id`,`version`,`resourceGroup`,`code`,`typeName`,`lastUpdatedBy`,`lastUpdate`) values (5,1,'FACILITY','CLASSROOM','Class Room',1,'2014-05-19 15:19:51');
insert  into `resource_types`(`id`,`version`,`resourceGroup`,`code`,`typeName`,`lastUpdatedBy`,`lastUpdate`) values (6,2,'FACILITY','VEHICLE','Vehicle',1,'2015-05-15 14:19:51');
insert  into `resource_types`(`version`,`resourceGroup`,`code`,`typeName`,`lastUpdatedBy`) values (0,'HOSTEL','HOSTEL','Hostel',1);
insert  into `resource_types`(`version`,`resourceGroup`,`code`,`typeName`,`lastUpdatedBy`) values (0,'HOSTEL','BUILDING','Building',1);
insert  into `resource_types`(`version`,`resourceGroup`,`code`,`typeName`,`lastUpdatedBy`) values (0,'HOSTEL','FLOOR','Floor',1);
insert  into `resource_types`(`version`,`resourceGroup`,`code`,`typeName`,`lastUpdatedBy`) values (0,'HOSTEL','ROOM','Room',1);

-- Billed User Type
insert  into `billed_user_type`(`id`,`billedUserType`,`raiseBillType`,`lastUpdatedBy`,`lastUpdate`) values (1,'STUDENT','P_AND_C_FEE',1,'2014-09-10 12:10:14');
insert  into `billed_user_type`(`id`,`billedUserType`,`raiseBillType`,`lastUpdatedBy`,`lastUpdate`) values (2,'APPLICANT','P_AND_C_FEE',1,'2014-09-10 12:10:14');
insert  into `billed_user_type`(`id`,`billedUserType`,`raiseBillType`,`lastUpdatedBy`,`lastUpdate`) values (3,'SPONSOR','P_AND_C_FEE',1,'2014-09-10 12:10:14');
insert  into `billed_user_type`(`id`,`billedUserType`,`raiseBillType`,`lastUpdatedBy`,`lastUpdate`) values (4,'USER','SERVICE_RECEIVED',1,'2014-09-10 12:10:14');
insert  into `billed_user_type`(`id`,`billedUserType`,`raiseBillType`,`lastUpdatedBy`,`lastUpdate`) values (5,'THIRD PARTY','DEPENDENT_BILLS',1,'2014-09-10 12:10:14');
insert  into `billed_user_type`(`id`,`billedUserType`,`raiseBillType`,`lastUpdatedBy`,`lastUpdate`) values (6,'STUDENT','SERVICE_PROVIDED',1,'2014-09-10 12:10:14');
insert  into `billed_user_type`(`id`,`billedUserType`,`raiseBillType`,`lastUpdatedBy`,`lastUpdate`) values (7,'USER','SERVICE_PROVIDED',1,'2014-09-10 12:10:14');
insert  into `billed_user_type`(`id`,`billedUserType`,`raiseBillType`,`lastUpdatedBy`,`lastUpdate`) values (8,'SPONSOR','SERVICE_PROVIDED',1,'2014-09-10 12:10:14');
insert  into `billed_user_type`(`id`,`billedUserType`,`raiseBillType`,`lastUpdatedBy`,`lastUpdate`) values (9,'STUDENT','SCHOLARSHIP',1,'2014-09-09 16:36:31');

insert  into `drop_down`(`id`,`lastUpdate`,`type`,`name`,`value`,`lastUpdatedBy`) values (1,'2012-01-01','AssignmentType','Individual','Individual',1);
insert  into `drop_down`(`id`,`lastUpdate`,`type`,`name`,`value`,`lastUpdatedBy`) values (2,'2012-01-01','AssignmentType','Group','Group',1);
insert  into `drop_down`(`id`,`lastUpdate`,`type`,`name`,`value`,`lastUpdatedBy`) values (3,'2012-01-01','AssignmentType','All','All',1);
insert  into `drop_down`(`id`,`lastUpdate`,`type`,`name`,`value`,`lastUpdatedBy`) values (4,'2012-01-01','topicType','General','General', 1);
insert  into `drop_down`(`id`,`lastUpdate`,`type`,`name`,`value`,`lastUpdatedBy`) values (5,'2012-01-01','topicType','Specific','Specific', 1);
-- seed data for file priority
insert  into `drop_down`(`id`,`lastUpdate`,`type`,`name`,`value`,`lastUpdatedBy`) values (6,'2016-01-01','FilePriority','Urgent','Urgent',1);
insert  into `drop_down`(`id`,`lastUpdate`,`type`,`name`,`value`,`lastUpdatedBy`) values (7,'2016-01-01','FilePriority','Medium','Medium', 1);
insert  into `drop_down`(`id`,`lastUpdate`,`type`,`name`,`value`,`lastUpdatedBy`) values (8,'2016-01-01','FilePriority','Low','Low', 1);


-- Enquiry Referrer Types
insert  into `enq_referrer_type`(`id`,`referrerType`,`lastUpdate`,`lastUpdatedBy`) values (1,'Student','2014-08-05 10:43:45',1);
insert  into `enq_referrer_type`(`id`,`referrerType`,`lastUpdate`,`lastUpdatedBy`) values (2,'Enquirer','2014-08-05 10:44:00',1);
insert  into `enq_referrer_type`(`id`,`referrerType`,`lastUpdate`,`lastUpdatedBy`) values (3,'Employee','2014-08-05 10:44:08',1);
insert  into `enq_referrer_type`(`id`,`referrerType`,`lastUpdate`,`lastUpdatedBy`) values (4,'External User','2014-08-05 10:44:18',1);
insert  into `enq_referrer_type`(`id`,`referrerType`,`lastUpdate`,`lastUpdatedBy`) values (5,'Others','2014-08-05 10:44:26',1);
insert  into `enq_referrer_type`(`id`,`referrerType`,`lastUpdate`,`lastUpdatedBy`) values (6,'Corporate','2014-11-27 11:32:24',1);
insert  into `enq_referrer_type`(`id`,`referrerType`,`lastUpdate`,`lastUpdatedBy`) values (7,'None','2014-08-05 10:44:33',1);

-- Enquiry Types
insert  into `enquiry_type` (`code`, `enquiryTypeName`, `lastUpdatedBy`) VALUES ('Admission', 'Admission', '1');
insert  into `enquiry_type` (`code`, `enquiryTypeName`, `lastUpdatedBy`) VALUES ('Counselling', 'Counselling', '1');
insert  into `enquiry_type` (`code`, `enquiryTypeName`, `lastUpdatedBy`) VALUES ('Corporate', 'Corporate', '1');

insert  into `fee_plan_submission_seq`(`id`,`sequence`,`lastUpdatedBy`,`lastUpdate`) values (1,1,1,'2014-08-25 18:36:08');
insert  into `fee_plan_submission_seq`(`id`,`sequence`,`lastUpdatedBy`,`lastUpdate`) values (2,2,1,'2014-08-25 18:36:08');
insert  into `fee_plan_submission_seq`(`id`,`sequence`,`lastUpdatedBy`,`lastUpdate`) values (3,3,1,'2014-08-25 18:36:08');
insert  into `fee_plan_submission_seq`(`id`,`sequence`,`lastUpdatedBy`,`lastUpdate`) values (4,4,1,'2014-08-26 11:32:39');
insert  into `fee_plan_submission_seq`(`id`,`sequence`,`lastUpdatedBy`,`lastUpdate`) values (5,5,1,'2014-08-26 11:32:39');
insert  into `fee_plan_submission_seq`(`id`,`sequence`,`lastUpdatedBy`,`lastUpdate`) values (6,6,1,'2014-08-26 11:32:39');
insert  into `fee_plan_submission_seq`(`id`,`sequence`,`lastUpdatedBy`,`lastUpdate`) values (7,7,1,'2014-08-26 11:32:39');
insert  into `fee_plan_submission_seq`(`id`,`sequence`,`lastUpdatedBy`,`lastUpdate`) values (8,8,1,'2014-08-26 11:32:39');
insert  into `fee_plan_submission_seq`(`id`,`sequence`,`lastUpdatedBy`,`lastUpdate`) values (9,9,1,'2014-08-26 11:32:39');
insert  into `fee_plan_submission_seq`(`id`,`sequence`,`lastUpdatedBy`,`lastUpdate`) values (10,10,1,'2014-08-26 11:32:39');
insert  into `fee_plan_submission_seq`(`id`,`sequence`,`lastUpdatedBy`,`lastUpdate`) values (11,11,1,'2014-08-26 11:32:39');
insert  into `fee_plan_submission_seq`(`id`,`sequence`,`lastUpdatedBy`,`lastUpdate`) values (12,12,1,'2014-08-26 11:32:39');
insert  into `fee_plan_submission_seq`(`id`,`sequence`,`lastUpdatedBy`,`lastUpdate`) values (13,13,1,'2014-08-26 11:32:39');
insert  into `fee_plan_submission_seq`(`id`,`sequence`,`lastUpdatedBy`,`lastUpdate`) values (14,14,1,'2014-08-26 11:32:39');
insert  into `fee_plan_submission_seq`(`id`,`sequence`,`lastUpdatedBy`,`lastUpdate`) values (15,15,1,'2014-08-26 11:32:39');
insert  into `fee_plan_submission_seq`(`id`,`sequence`,`lastUpdatedBy`,`lastUpdate`) values (16,16,1,'2014-08-26 11:32:39');
insert  into `fee_plan_submission_seq`(`id`,`sequence`,`lastUpdatedBy`,`lastUpdate`) values (17,17,1,'2014-08-26 11:32:39');
insert  into `fee_plan_submission_seq`(`id`,`sequence`,`lastUpdatedBy`,`lastUpdate`) values (18,18,1,'2014-08-26 11:32:39');
insert  into `fee_plan_submission_seq`(`id`,`sequence`,`lastUpdatedBy`,`lastUpdate`) values (19,19,1,'2014-08-26 11:32:39');
insert  into `fee_plan_submission_seq`(`id`,`sequence`,`lastUpdatedBy`,`lastUpdate`) values (20,20,1,'2014-08-26 11:32:39');
insert  into `fee_plan_submission_seq`(`id`,`sequence`,`lastUpdatedBy`,`lastUpdate`) values (21,21,1,'2014-08-26 11:32:39');
insert  into `fee_plan_submission_seq`(`id`,`sequence`,`lastUpdatedBy`,`lastUpdate`) values (22,22,1,'2014-08-26 11:32:39');
insert  into `fee_plan_submission_seq`(`id`,`sequence`,`lastUpdatedBy`,`lastUpdate`) values (23,23,1,'2014-08-26 11:32:39');
insert  into `fee_plan_submission_seq`(`id`,`sequence`,`lastUpdatedBy`,`lastUpdate`) values (24,24,1,'2014-08-26 11:32:39');

insert  into `fee_plan_type`(`id`,`feePlanType`,`lastUpdatedBy`,`lastUpdate`) values (1,'Application',1,'2014-08-09 15:27:22');
insert  into `fee_plan_type`(`id`,`feePlanType`,`lastUpdatedBy`,`lastUpdate`) values (2,'Program',1,'2014-11-07 11:06:40');
insert  into `fee_plan_type`(`id`,`feePlanType`,`lastUpdatedBy`,`lastUpdate`) values (3,'Services',1,'2014-08-09 15:27:22');
insert  into `fee_plan_type`(`id`,`feePlanType`,`lastUpdatedBy`,`lastUpdate`) values (4,'Courses',1,'2014-08-09 15:27:22');
insert  into `fee_plan_type`(`id`,`feePlanType`,`lastUpdatedBy`,`lastUpdate`) values (5,'Exam',1,'2014-11-07 11:06:40');


insert  into `fee_stage_master`(`id`,`stageName`,`feePlanType`,`lastUpdate`,`lastUpdatedBy`) values (1,'Application form sale',1,'2014-08-05 07:28:00',1);
insert  into `fee_stage_master`(`id`,`stageName`,`feePlanType`,`lastUpdate`,`lastUpdatedBy`) values (2,'Application submission',1,'2014-08-05 07:28:00',1);
insert  into `fee_stage_master`(`id`,`stageName`,`feePlanType`,`lastUpdate`,`lastUpdatedBy`) values (3,'Selection process',2,'2014-08-05 07:28:00',1);
insert  into `fee_stage_master`(`id`,`stageName`,`feePlanType`,`lastUpdate`,`lastUpdatedBy`) values (4,'Admission commitment',2,'2014-08-05 07:28:00',1);
insert  into `fee_stage_master`(`id`,`stageName`,`feePlanType`,`lastUpdate`,`lastUpdatedBy`) values (5,'Admission',2,'2014-08-05 07:28:00',1);
insert  into `fee_stage_master`(`id`,`stageName`,`feePlanType`,`lastUpdate`,`lastUpdatedBy`) values (6,'Course execution',2,'2014-08-05 07:28:00',1);
insert  into `fee_stage_master`(`id`,`stageName`,`feePlanType`,`lastUpdate`,`lastUpdatedBy`) values (7,'Course enrollment',4,'2014-08-05 07:28:00',1);
insert  into `fee_stage_master`(`id`,`stageName`,`feePlanType`,`lastUpdate`,`lastUpdatedBy`) values (8,'Course execution',4,'2014-08-05 07:28:00',1);
insert  into `fee_stage_master`(`id`,`stageName`,`feePlanType`,`lastUpdate`,`lastUpdatedBy`) values (9,'Default stage',3,'2014-08-05 07:28:00',1);
insert  into `fee_stage_master`(`id`,`stageName`,`feePlanType`,`lastUpdate`,`lastUpdatedBy`) values (10,'Detail sequence',5,'2014-08-05 07:28:00',1);
insert  into `fee_stage_master`(`id`,`stageName`,`feePlanType`,`lastUpdate`,`lastUpdatedBy`) values (11,'Assessment group',5,'2014-08-05 07:28:00',1);
insert  into `fee_stage_master`(`id`,`stageName`,`feePlanType`,`lastUpdate`,`lastUpdatedBy`) values (12,'Repetition',4,'2014-08-05 07:28:00',1);
insert  into `fee_stage_master`(`id`,`stageName`,`feePlanType`,`lastUpdate`,`lastUpdatedBy`) values (13,'Course enrollment',2,'2014-08-05 07:28:00',1);
insert  into `fee_stage_master`(`id`,`stageName`,`feePlanType`,`lastUpdate`,`lastUpdatedBy`) values (14,'Provisional',2,'2014-08-05 07:28:00',1);
insert  into `fee_stage_master`(`id`,`stageName`,`feePlanType`,`lastUpdate`,`lastUpdatedBy`) values (15,'Admission after provisional',2,'2014-08-05 07:28:00',1);

-- Resource Booking Seed Data
insert  into `booking_purposes`(`id`,`code`,`value`,`lastUpdatedBy`,`lastUpdate`,`version`) values (1,'ACAD','Academic',1,'2014-05-13',0);
insert  into `booking_purposes`(`id`,`code`,`value`,`lastUpdatedBy`,`lastUpdate`,`version`) values (2,'NON_ACAD','Non Academic',1,'2014-05-15',0);
insert  into `booking_purposes`(`id`,`code`,`value`,`lastUpdatedBy`,`lastUpdate`,`version`) values (3,'SELECT','Selection Process',1,'2014-05-15',0);
insert  into `booking_purposes`(`id`,`code`,`value`,`lastUpdatedBy`,`lastUpdate`,`version`) values (4,'ADM','Admission Process',1,'2014-05-15',0);
insert  into `booking_purposes`(`id`,`code`,`value`,`lastUpdatedBy`,`lastUpdate`,`version`) values (5,'EXAM','Examination',1,'2014-05-19',0);
insert  into `booking_purposes`(`id`,`code`,`value`,`lastUpdatedBy`,`lastUpdate`,`version`) values (6,'ORG','Organization Level',1,'2014-05-19',0);
insert  into `booking_purposes`(`id`,`code`,`value`,`lastUpdatedBy`,`lastUpdate`,`version`) values (7,'EXT_EVENT','External Event',1,'2016-11-09',0);
-- Media Records
insert into media(code,mediaName,lastUpdatedBy,lastUpdate) values('Newspaper','Newspaper',1,sysdate());
insert into media(code,mediaName,lastUpdatedBy,lastUpdate) values('Website','Website',1,sysdate());
insert into media(code,mediaName,lastUpdatedBy,lastUpdate) values('Television','Television',1,sysdate());
insert into media(code,mediaName,lastUpdatedBy,lastUpdate) values('Radio','Radio',1,sysdate());

-- Post Enquiry status
insert into closure_reason(reasonCode,status,lastUpdatedBy,lastUpdate) values('Already Admitted','Already Admitted',1,sysdate());
insert into closure_reason(reasonCode,status,lastUpdatedBy,lastUpdate) values('Not Interested','Not Interested',1,sysdate());
insert into closure_reason(reasonCode,status,lastUpdatedBy,lastUpdate) values('Not Reachable,Wrong Phone No','Not Reachable,Wrong Phone No',1,sysdate());
insert into closure_reason(reasonCode,status,lastUpdatedBy,lastUpdate) values('Closed Successfully','Closed Successfully',1,sysdate());

-- Enquiry Reopen status 
insert into reopen_reason(reasonCode,status,lastUpdatedBy,lastUpdate) values('Interested in Admission','Interested in Admission ',1,sysdate());

-- Fee Payment Modes
INSERT INTO `fee_payment_modes` (`id`, `paymentModeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('1', 'Cheque', '1', '2014-11-05 11:57:34');
INSERT INTO `fee_payment_modes` (`id`, `paymentModeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('2', 'Debit Card', '1', '2014-11-05 11:57:45');
INSERT INTO `fee_payment_modes` (`id`, `paymentModeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('3', 'Credit Card', '1', '2014-11-05 11:58:05');
INSERT INTO `fee_payment_modes` (`id`, `paymentModeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('4', 'Demand Draft', '1', '2014-11-11 18:32:33');
INSERT INTO `fee_payment_modes` (`id`, `paymentModeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('5', 'Online Transfer', '1', '2014-11-11 18:32:33');

-- Fee Refund Modes
INSERT INTO `fee_refund_modes` (`refundModeName`, `lastUpdatedBy`, `lastUpdate`) VALUES ('Cheque', '1', NULL);
INSERT INTO `fee_refund_modes` (`refundModeName`, `lastUpdatedBy`) VALUES ('Online Transfer', '1');

-- Leave Status
INSERT INTO `leave_status` VALUES (1,'Applied','2014-09-27 12:16:13',1), (2,'Approved','2014-09-27 12:16:13',1), (3,'Rejected','2014-09-27 12:16:13',1), (4,'Unauthorized Absence','2014-09-27 12:16:13',1);

INSERT INTO `calendars` VALUES (1,'cal1','Org Calender','Org Calender','ACTIVE','MONDAY',NULL,1,'2014-04-27 04:49:32',0);

INSERT INTO `enq_intermediate_type` VALUES (1,'Unassigned','',1,'2014-11-21 07:01:45'),(2,'Genuine','\0',1,'2014-11-21 07:01:45'),(3,'Assigned to Call center','\0',1,'2014-11-21 07:01:45'),(4,'Interested in Enrolment','\0',1,'2014-11-21 07:01:45'),(5,'Application Sent','\0',1,'2014-11-21 07:01:45'),(6,'Application Submitted','\0',1,'2014-11-21 07:01:45'),(7,'Enrolled','\0',1,'2014-11-21 07:01:45'),(8,'Withdrawn','\0',1,'2014-11-21 07:01:45'),(9,'Completed','\0',1,'2014-11-21 07:01:45');

INSERT INTO `enq_priority` VALUES (1,'High','','2014-08-18 02:32:28',1),(2,'Low','\0','2014-08-18 02:32:47',1),(3,'Medium','\0','2014-08-18 02:32:57',1);

/*Data for the table `transaction_types` */
insert  into `transaction_types`(`id`,`completionTransactionType`,`lastUpdate`,`itemCode`,`itemValue`,`lastUpdatedBy`) values (1,'PASSING_OUT','2015-01-28 18:24:21','PASSING_OUT','Passing Out',1);
insert  into `transaction_types`(`id`,`completionTransactionType`,`lastUpdate`,`itemCode`,`itemValue`,`lastUpdatedBy`) values(2,'TERMINATION','2015-01-28 18:24:21','TERMINATION','Termination',1);
insert  into `transaction_types`(`id`,`completionTransactionType`,`lastUpdate`,`itemCode`,`itemValue`,`lastUpdatedBy`) values(3,'TEMPORARY_TERMINATION','2015-01-28 18:24:53','TEMPORARY_TERMINATION','Temporary Termination',1);
insert  into `transaction_types`(`id`,`completionTransactionType`,`lastUpdate`,`itemCode`,`itemValue`,`lastUpdatedBy`) values(4,'TRANSFER','2015-01-28 18:24:53','TRANSFER','Transfer',1);
insert  into `transaction_types`(`id`,`completionTransactionType`,`lastUpdate`,`itemCode`,`itemValue`,`lastUpdatedBy`) values(5,'WITHDRAW_PROGRAM','2015-01-28 18:24:53','WITHDRAW_PROGRAM','Withdraw Program',1);
insert  into `transaction_types`(`id`,`completionTransactionType`,`lastUpdate`,`itemCode`,`itemValue`,`lastUpdatedBy`) values(6,'ADMISSION','2015-01-28 18:24:53','ADMISSION','Admission',1);
insert  into `transaction_types`(`id`,`completionTransactionType`,`lastUpdate`,`itemCode`,`itemValue`,`lastUpdatedBy`) values(7,'APPLICATION','2015-01-28 18:24:53','APPLICATION','Application',1);

/* Seed data for Standard Master custom category and fields*/
insert  into `standard_master_category`(`id`,`tableName`,`displayName`,`displayColumnName`,`customQuery`) values (1,'city','City','cityName','SELECT id AS id,cityName AS VALUE FROM city;'),(2,'country','Country','countryName','SELECT id AS id,countryName AS VALUE FROM country;'); 

/* Seed data for custom category and fields*/
INSERT INTO `custom_table_configs`(`displayName`,`tableName`,`customTableName`) VALUES ('Academy','academies','academies_cd');
INSERT INTO `custom_table_configs`(`displayName`,`tableName`,`customTableName`) VALUES ('Applicant Education History', 'applicant_education_histories', 'applicant_education_histories_cd');
INSERT INTO `custom_table_configs`(`displayName`,`tableName`,`customTableName`) VALUES ('Course', 'courses', 'course_cd');
INSERT INTO `custom_table_configs`(`displayName`,`tableName`,`customTableName`) VALUES ('Course Reading', 'course_reading', 'course_reading_cd');
INSERT INTO `custom_table_configs`(`displayName`,`tableName`,`customTableName`) VALUES ('Applicant Person', 'applicant_person', 'applicant_person_cd');
INSERT INTO `custom_table_configs`(`displayName`,`tableName`,`customTableName`) VALUES ('Course Topic', 'course_topics', 'course_topic_cd');
INSERT INTO `custom_table_configs`(`displayName`,`tableName`,`customTableName`) VALUES ('Batches', 'batches', 'batches_cd');
INSERT INTO `custom_table_configs`(`displayName`,`tableName`,`customTableName`) VALUES ('Program Batch Period', 'prog_batch_period_config', 'program_batch_period_cd');
INSERT INTO `custom_table_configs`(`displayName`,`tableName`,`customTableName`) VALUES ('Assignment Details', 'course_hw_asignment', 'home_work_assignment_cd');
INSERT INTO `custom_table_configs`(`displayName`,`tableName`,`customTableName`) VALUES ('Submission Assessment Details', 'group_hw_assignment', 'group_hw_assignment_cd');
INSERT INTO `custom_table_configs` (`displayName`, `tableName`, `customTableName`) VALUES ('Enquiry', 'enquiry', 'enquiry_cd');
INSERT INTO `custom_table_configs` (`displayName`, `tableName`, `customTableName`) VALUES ('Campaign', 'campaign', 'campaign_cd');
INSERT INTO `custom_table_configs` (`displayName`,`tableName`,`customTableName`) VALUES ('Enquiry Student Details','enq_student_details','enquiry_student_detail_cd');
INSERT INTO `custom_table_configs` (`displayName`,`tableName`,`customTableName`) VALUES ('Enquiry Exam Details','enq_exams_details','enquiry_exam_detail_cd');
INSERT INTO `custom_table_configs` (`displayName`,`tableName`,`customTableName`) VALUES ('Person','persons','person_cd');
INSERT INTO `custom_table_configs` (`displayName`,`tableName`,`customTableName`) VALUES ('Education History','education_histories','education_history_cd');
INSERT INTO `custom_table_configs` (`displayName`,`tableName`,`customTableName`) VALUES ('Applicant Work Experience','applicant_work_experience','applicant_work_experience_cd');
INSERT INTO `custom_table_configs` (`displayName`,`tableName`,`customTableName`) VALUES ('Work Experience','work_experience','work_experience_cd');
INSERT INTO `custom_table_configs` (`displayName`,`tableName`,`customTableName`) VALUES ('Program','programs','program_cd');
INSERT INTO `custom_table_configs` (`displayName`,`tableName`,`customTableName`) VALUES ('Program Batch Seat Type','prog_batch_seat_config','program_batch_seat_type_cd');
INSERT INTO `custom_table_configs` (`displayName`,`tableName`,`customTableName`) VALUES ('Examination Documents','examination_documents','exam_document_cd');
-- add Other Information for custom field / custom category
SET @currentTimeStamp = (SELECT CURRENT_TIMESTAMP);
-- For Student Other Info
SET @customTableId=(SELECT MAX(id) FROM custom_table_configs);
INSERT INTO `custom_table_configs` (`id`,`displayName`,`tableName`,`customTableName`) 
VALUES (@customTableId+1, 'Student Other Information','student_other_information','student_other_information_cd');
-- adding 2 default values
SET @customFieldId=(SELECT MAX(id) FROM custom_field_config);
INSERT INTO custom_field_config (id, whetherCustomField, customFieldDataType, customTableConfigId, columnMappingId, displayName, whetherMandatory, displayOrder, whetherStandardMaster, lastUpdate, lastUpdatedBy) 
VALUES(@customFieldId+1, 1, 'TEXTFIELD', @customTableId+1, 1, 'Custom Field 1', 0, 1, 0, @currentTimeStamp, 1);
SET @customFieldId=(SELECT MAX(id) FROM custom_field_config);
INSERT INTO custom_field_config (id, whetherCustomField, customFieldDataType, customTableConfigId, columnMappingId, displayName, whetherMandatory, displayOrder, whetherStandardMaster, lastUpdate, lastUpdatedBy) 
VALUES(@customFieldId+1, 1, 'TEXTFIELD', @customTableId+1, 2, 'Custom Field 2', 0, 2, 0, @currentTimeStamp, 1);

-- For Employee Other Info
SET @customTableId=(SELECT MAX(id) FROM custom_table_configs);
INSERT INTO `custom_table_configs` (`id`,`displayName`,`tableName`,`customTableName`) 
VALUES (@customTableId+1, 'Employee Other Information','staff_other_information','staff_other_information_cd');
-- adding 2 default values
SET @customFieldId=(SELECT MAX(id) FROM custom_field_config);
INSERT INTO custom_field_config (id, whetherCustomField, customFieldDataType, customTableConfigId, columnMappingId, displayName, whetherMandatory, displayOrder, whetherStandardMaster, lastUpdate, lastUpdatedBy) 
VALUES(@customFieldId+1, 1, 'TEXTFIELD', @customTableId+1, 1, 'Custom Field 1', 0, 1, 0, @currentTimeStamp, 1);
SET @customFieldId=(SELECT MAX(id) FROM custom_field_config);
INSERT INTO custom_field_config (id, whetherCustomField, customFieldDataType, customTableConfigId, columnMappingId, displayName, whetherMandatory, displayOrder, whetherStandardMaster, lastUpdate, lastUpdatedBy) 
VALUES(@customFieldId+1, 1, 'TEXTFIELD', @customTableId+1, 2, 'Custom Field 2', 0, 2, 0, @currentTimeStamp, 1);

-- For Applicant Other Info
SET @customTableId=(SELECT MAX(id) FROM custom_table_configs);
INSERT INTO `custom_table_configs` (`id`,`displayName`,`tableName`,`customTableName`) 
VALUES (@customTableId+1, 'Applicant Other Information','applicant_other_information','applicant_other_information_cd');
-- adding 2 default values
SET @customFieldId=(SELECT MAX(id) FROM custom_field_config);
INSERT INTO custom_field_config (id, whetherCustomField, customFieldDataType, customTableConfigId, columnMappingId, displayName, whetherMandatory, displayOrder, whetherStandardMaster, lastUpdate, lastUpdatedBy) 
VALUES(@customFieldId+1, 1, 'TEXTFIELD', @customTableId+1, 1, 'Custom Field 1', 0, 1, 0, @currentTimeStamp, 1);
SET @customFieldId=(SELECT MAX(id) FROM custom_field_config);
INSERT INTO custom_field_config (id, whetherCustomField, customFieldDataType, customTableConfigId, columnMappingId, displayName, whetherMandatory, displayOrder, whetherStandardMaster, lastUpdate, lastUpdatedBy) 
VALUES(@customFieldId+1, 1, 'TEXTFIELD', @customTableId+1, 2, 'Custom Field 2', 0, 2, 0, @currentTimeStamp, 1);

-- Course Session Diary
SET @customTableId=(SELECT MAX(id) FROM custom_table_configs);
INSERT INTO `custom_table_configs` (`id`,`displayName`,`tableName`,`customTableName`) VALUES (@customTableId+1, 'Course Session Diary','course_session_diary','course_session_diary_cd');


/* Seed data for custom category - Column mappings */
insert  into `column_mappings`(`id`,`customFieldDataType`,`columnName`,`customType`) values (1,'TEXTFIELD','cf1','CUSTOM_FIELD'),(2,'TEXTFIELD','cf2','CUSTOM_FIELD'),(3,'TEXTFIELD','cf3','CUSTOM_FIELD'),(4,'TEXTFIELD','cf4','CUSTOM_FIELD'),(5,'TEXTFIELD','cf5','CUSTOM_FIELD'),(6,'TEXTFIELD','cf6','CUSTOM_FIELD'),(7,'TEXTFIELD','cf7','CUSTOM_FIELD'),(8,'TEXTFIELD','cf8','CUSTOM_FIELD'),(9,'TEXTFIELD','cf9','CUSTOM_FIELD'),(10,'TEXTFIELD','cf10','CUSTOM_FIELD'),(11,'COMBOBOX','cf11','CUSTOM_CATEGORY'),(12,'COMBOBOX','cf12','CUSTOM_CATEGORY'),(13,'COMBOBOX','cf13','CUSTOM_CATEGORY'),(14,'DATEFIELD','cf14','CUSTOM_FIELD'),(15,'DATEFIELD','cf15','CUSTOM_FIELD'),(16,'CHECKBOX','cf16','CUSTOM_FIELD'),(17,'CHECKBOX','cf17','CUSTOM_FIELD'),(18,'TEXTAREA','cf18','CUSTOM_FIELD'),(19,'TEXTAREA','cf19','CUSTOM_FIELD');

-- Enquiry Import Master
INSERT INTO `import_utility_master` (`id`,`screenName`,`fileDirectory`,`code`,`lastUpdate`,`lastUpdatedBy`) VALUES (1,'Enquiry','preadmission/enquiry','enquiry','2015-03-30 10:39:00',1);
/***Mark Attendance complete Day for Import Utility*****/
INSERT INTO `import_utility_master` (`screenName`, `fileDirectory`, `code`, `lastUpdatedBy`) VALUES ('MarkAttendanceForCompleteday', 'attendance/completeday', 'markattendance', '1');
/*****For Mark entry import utility********************/
INSERT INTO `import_utility_master` (`screenName`, `fileDirectory`, `code`, `lastUpdatedBy`) VALUES ('MarkEntry', 'exam/markentry', 'markentry', '1');
/*************For Direct admission********************/
INSERT INTO `import_utility_master` (`screenName`, `fileDirectory`, `code`, `lastUpdatedBy`) VALUES ('Bulk Admissions', 'admission/student', 'bulkadmission', '1');

/********For FeePlanPersonCoveredImoprtUtilty*****************/
INSERT INTO `import_utility_master` (`screenName`, `fileDirectory`, `code`, `lastUpdatedBy`) VALUES('Bulk Person Covered', 'feeplan/personcoverd', 'feePlanPersonCoverd', '1');
/************For Master time table import util************/
INSERT INTO `import_utility_master` (`screenName`, `fileDirectory`, `code`, `lastUpdatedBy`) VALUES ('MasterTimeTable', 'master/timetable', 'masterTimeTable', '1');
/************For Mange Receipt Import Utility****************/
INSERT INTO `import_utility_master` (`screenName`, `fileDirectory`, `code`, `lastUpdatedBy`) VALUES ('Bulk Receipts', 'fees/receipt', 'receipt', '1');
/************For Mange Student Profile Update Import Utility****************/
INSERT INTO `import_utility_master` (`screenName`, `fileDirectory`, `code`, `lastUpdatedBy`) VALUES ('Bulk Update Students', 'students/profile', 'studentProfileUpdate', '1');
/*************For Student Relationship Import********************/
INSERT INTO `import_utility_master` (`screenName`, `fileDirectory`, `code`, `lastUpdatedBy`) VALUES ('Bulk Student RelationShip','students/relationship', 'studentRelationShip', '1');
/*************Hostel Bed Import********************/
INSERT INTO `import_utility_master` (`screenName`, `fileDirectory`, `code`, `lastUpdatedBy`) VALUES ('Bulk Hostel Bed', 'hostel/bed', 'hostelbed', '1');

/**************Hostel Check-In Import****************/
INSERT INTO `import_utility_master` (`screenName`, `fileDirectory`, `code`, `lastUpdatedBy`) VALUES ('Bulk Hostel Chek-In', 'hostel/allocation', 'hostelallocation', '1');
/************Student Course Enrollment Import*************/
INSERT INTO `import_utility_master` (`screenName`, `fileDirectory`, `code`,`lastUpdatedBy`) VALUES ('Bulk Student Course Enrollments', 'student/courseenrollment', 'studentcourseenrollment', '1');
/*********Bill Import**********/
INSERT INTO `import_utility_master` (`screenName`, `fileDirectory`, `code`, `lastUpdatedBy`) VALUES ('Bulk Bills', 'feesandpayments/bill', 'bill', '1');
/**********User Creation Import**********/
INSERT INTO `import_utility_master` (`screenName`, `fileDirectory`, `code`, `lastUpdatedBy`) VALUES ('Bulk Users', 'usercreation/user', 'usercreation', '1');
/*******************Application Creation Import insert******************/
INSERT INTO `import_utility_master` (`screenName`, `fileDirectory`, `code`, `lastUpdatedBy`) VALUES ('Bulk Applications', 'applicantcreation/applicant', 'applicantcreation', '1');
/********************Section Transfer***********/
INSERT INTO `import_utility_master` (`screenName`, `fileDirectory`, `code`, `lastUpdatedBy`) VALUES ('Bulk Student Sections', 'student/sectiontransfer', 'studentsectionenrollment', '1');
/******************Selection Stage Marks************/
INSERT INTO `import_utility_master` (`screenName`, `fileDirectory`, `code`, `lastUpdatedBy`) VALUES ('Bulk Selection Stage Marks', 'selectionstage/marks', 'selectionstagemarks', '1');
/***************Empolyee Profile Update**********/
INSERT INTO `import_utility_master` (`screenName`, `fileDirectory`, `code`, `lastUpdatedBy`) VALUES ('Bulk Employee Update', 'emp/employeeupdate', 'employeeupdate', '1');
/**************User Role*****************/
INSERT INTO `import_utility_master` (`screenName`, `fileDirectory`, `code`, `lastUpdatedBy`) VALUES ('Bulk User Role', 'user/userrole', 'userrole', '1');
/****************CBS Time Table**********************/
INSERT INTO `import_utility_master` (`screenName`, `fileDirectory`, `code`, `lastUpdatedBy`) VALUES ('Bulk CBS TimeTable', 'cbs/timetable', 'cbstimetable', '1');
/*******************************Course Level Attendance**************************/
INSERT INTO `import_utility_master` (`screenName`, `fileDirectory`, `code`, `lastUpdatedBy`) VALUES ('Bulk Course Level Attendance', 'course/courselevelattendance', 'courselevelattendance', '1');
/*****************Exam Remark************/
INSERT INTO `import_utility_master` (`screenName`, `fileDirectory`, `code`, `lastUpdatedBy`) VALUES ('Bulk Exam Remark', 'remark/examremark', 'examremark', '1');
/****************Course Parmeter***************/
INSERT INTO `import_utility_master` (`screenName`, `fileDirectory`, `code`, `lastUpdatedBy`) VALUES ('Bulk CourseParameter', 'course/parameter', 'courseparameter', '1');
/****************Section Creation***************/
INSERT INTO `import_utility_master` (`screenName`, `fileDirectory`, `code`, `lastUpdatedBy`) VALUES ('Bulk Section Creation', 'section/creation', 'sectioncreation', '1');
/****************Course Faculty Mapping***************/
INSERT INTO `import_utility_master` (`screenName`, `fileDirectory`, `code`, `lastUpdatedBy`) VALUES ('Bulk Course Faculty Mapping', 'course/coursefaculty', 'coursefacultymapping', '1');
/*******************Course With Component*************/
INSERT INTO `import_utility_master` (`screenName`, `fileDirectory`, `code`, `lastUpdatedBy`) VALUES ('Bulk Course With Component', 'course/coursewithcomponent', 'coursewithcomponent', '1');
/******************************* Student Academic Topic **************************/
INSERT INTO `import_utility_master` (`screenName`, `fileDirectory`, `code`, `lastUpdatedBy`) VALUES ('Bulk Student Academic Topic', 'students/academictopic', 'studentacademictopic', '1');
/********************Import Program Creation*********************/
INSERT INTO `import_utility_master` (`screenName`, `fileDirectory`, `code`, `lastUpdatedBy`) VALUES ('Bulk Program', 'program/programcreation', 'programcreation', '1');
/******************Import Batch Creation******************/
INSERT INTO `import_utility_master` (`screenName`, `fileDirectory`, `code`, `lastUpdatedBy`) VALUES ('Bulk Batch', 'batch/batchcreation', 'batchcreation', '1');
/******************Import Batch Seat Type Mapping******************/
INSERT INTO `import_utility_master` (`screenName`, `fileDirectory`, `code`, `lastUpdatedBy`) VALUES ('Bulk Batch Seat Type Mapping', 'batch/seattype', 'batchseattypemapping', '1');
/*****************Import Peiod Creation****************/
INSERT INTO `import_utility_master` (`screenName`, `fileDirectory`, `code`, `lastUpdatedBy`) VALUES ('Bulk Periods', 'periods/period', 'period', '1');
/****************Import Facility and Master****************/
INSERT INTO `import_utility_master` (`screenName`, `fileDirectory`, `code`, `lastUpdatedBy`) VALUES ('Bulk FacilityMaster', 'facilitmasters/facility', 'facilitymaster', '1');
/*****************Import Hostel Creation*************/
INSERT INTO `import_utility_master` (`screenName`, `fileDirectory`, `code`, `lastUpdatedBy`) VALUES ('Bulk Hostel', 'hostel/creation', 'hostelcreation', '1');
/*********************Import Competetive Exam********/
INSERT INTO `import_utility_master` (`screenName`, `fileDirectory`, `code`, `lastUpdatedBy`) VALUES ('Bulk Competitive Exam', 'competetiveexam/creation', 'competetiveexamcreation', '1');
/*********************Import Education History**********/
INSERT INTO `import_utility_master` (`screenName`, `fileDirectory`, `code`, `lastUpdatedBy`) VALUES ('Bulk Education History', 'educationhistory/creation', 'educationhistorycreation', '1');
/** Import Enquiry New */
INSERT INTO `import_utility_master` (`screenName`, `fileDirectory`, `code`, `lastUpdatedBy`) VALUES ('Bulk Enquiry New', 'preadmission/enquiryNew', 'enquiryNew', '1');
/*********Import Bulk Appliaction***********/
INSERT INTO `import_utility_master` (`screenName`, `fileDirectory`, `code`, `lastUpdatedBy`) VALUES ('Bulk Application New', 'application/applicationcreation', 'applicationNew', '1');
/*********Import Assessment Event***********/
INSERT INTO `import_utility_master` (`screenName`, `fileDirectory`, `code`, `lastUpdatedBy`) VALUES ('Bulk Assessment Event', 'exam/assessmentevent', 'assessmentevent', '1');
/*********Import Bulk Discounts***********/
INSERT INTO `import_utility_master` (`screenName`, `fileDirectory`, `code`, `lastUpdatedBy`) VALUES ('Bulk Discounts', 'feesandpayments/discounts', 'discounts', '1');
/*********Import Assign Remark***********/
INSERT INTO `import_utility_master` (`screenName`, `fileDirectory`, `code`, `lastUpdatedBy`) VALUES ('Bulk Remarks', 'exam/assignremark', 'assignremark', '1');
/*********Bulk Doument Upload***********/
INSERT INTO `import_utility_master` (`screenName`, `fileDirectory`, `code`, `lastUpdatedBy`) VALUES ('Bulk Documents', 'setup/documentupload', 'documentupload', '1');
/********************Import Program Sequence*********************/
INSERT INTO `import_utility_master` (`screenName`, `fileDirectory`, `code`, `lastUpdatedBy`) VALUES ('Bulk Program Sequence', 'program/programsequence', 'programsequence', '1');
/********************Import Batch Courses *********************/
INSERT INTO `import_utility_master` (`screenName`, `fileDirectory`, `code`, `lastUpdatedBy`) VALUES ('Bulk Batch Courses Mapping', 'program/batchcourses', 'batchcourses', '1');
/********************Import Employee Attendance *********************/
INSERT INTO `import_utility_master` (`screenName`, `fileDirectory`, `code`, `lastUpdatedBy`) VALUES ('Bulk Employee Attendance', 'emp/employeeattendance', 'employeeattendance', '1');
/********************Import User Update *********************/
INSERT INTO `import_utility_master` (`screenName`, `fileDirectory`, `code`, `lastUpdatedBy`) VALUES ('Bulk User Update', 'user/userupdate', 'userupdate', '1');
/********************Import User Update *********************/
INSERT INTO `import_utility_master` (`screenName`, `fileDirectory`, `code`, `lastUpdatedBy`) VALUES ('Bulk Payments', 'feesandpayments/payments', 'payments', '1');
/********************Import User Update *********************/
INSERT INTO `import_utility_master` (`screenName`, `fileDirectory`, `code`, `lastUpdatedBy`) VALUES ('Bulk Sponsorship Awardee', 'feesandpayments/sponsorship', 'sponsorship', '1');
/************* For drool rules ************/

insert into drool_rules values
(1,'NEW_BODY_WEIGHT_RESULT_CALCULATION','New Body Weight Rule','EXAM',NULL,1,now()),
(2,'NEW_BODY_HEIGHT_RESULT_CALCULATION','New Body Height Rule','EXAM',NULL,1,now()),
(3,'NEW_STANDING_LONG_JUMP_RESULT_CALCULATION','New Long Jump Result Rule','EXAM',NULL,1,now()),
(4,'NEW_PACER_20M_RESULT_CALCULATION','New Pacer Result Calculation','EXAM',NULL,1,now()),
(5,'NEW_CURL_UPS_RESULT_CALCULATION','New Curl Ups Result Rule','EXAM',NULL,1,now()),
(6,'NEW_TRUNK_LIFT_RESULT_CALCULATION','New Trunk Lift Result Rule','EXAM',NULL,1,now()),
(7,'NEW_SIT_AND_REACH_RESULT_CALCULATION','New Sit And Reach Result Rule','EXAM',NULL,1,now()),
(8,'NEW_ZIPPER_RESULT_CALCULATION','New Zipper Result Rule','EXAM',NULL,1,now()),
(9,'BODY_MASS_INDEX_RESULT_CALCULATION', 'New Body Mass Index Rule', 'EXAM',NULL, '1',now()),
(10,'EXAMINATION_REVALUATION_CALCULATION_RULE', 'Revaluation Calculation', 'REVALUATION', 'Mean and > to 10% of event max marks logic for Calculation.', '1',now()),
(11,'EXAMINATION_CHALLENGE_CALCULATION_RULE', 'Challenge Calculation', 'REVALUATION', 'If marks changes > to 10% of event max marks will be reflected', '1',now()),
(12,'EXAMINATION_REVIEW_CALCULATION_RULE', 'Review Calculation', 'REVALUATION', 'If any marks changes > to previous marks will be reflected.', '1',now()),
(13,'REVEISED_GRADE_CALCULATION', 'Reveised Grade Calculation', 'REVEISED_GRADE', '100-90 No grade drop, 89-80 One grade drop, Below 80 Two grade drop', '1',now());

/********************For Employee Profile **************************/
INSERT INTO `roles` (`roleName`, `roleDesc`, `whetherDeletable`, `createdOn`, `whetherEditable`, `whetherDeleted`, `serialNumber`, `lastUpdatedBy`, `lastUpdate`, `version`) VALUES ('EMPLOYEE', 'Employee', 0, CURDATE(), 0, 0, 'EMPLOYEE01', '1', now(), '0');

SET @idRole=(SELECT id FROM roles  where `roleName`='EMPLOYEE' limit 1);
insert  into `role_portals`(`roleId`,`portalId`,`lastUpdate`,`lastUpdatedBy`) values (@idRole, 2, now(), 1);

UPDATE `portals` SET `portalName`='Employee', `portalDesc`='Employee' WHERE `id`='2';

INSERT INTO `role_privileges` (`whetherOverrideAllowed`,`granted`,`featurePrivilegeId`,`roleId`,`lastUpdatedBy`,`lastUpdate`) VALUES (0,1,2312,@idRole,1,'2016-05-26 18:09:57');
INSERT INTO `role_privileges` (`whetherOverrideAllowed`,`granted`,`featurePrivilegeId`,`roleId`,`lastUpdatedBy`,`lastUpdate`) VALUES (0,1,2635,@idRole,1,'2016-05-26 18:09:57');
INSERT INTO `role_privileges` (`whetherOverrideAllowed`,`granted`,`featurePrivilegeId`,`roleId`,`lastUpdatedBy`,`lastUpdate`) VALUES (0,1,2360,@idRole,1,'2016-05-26 18:09:57');
INSERT INTO `role_privileges` (`whetherOverrideAllowed`,`granted`,`featurePrivilegeId`,`roleId`,`lastUpdatedBy`,`lastUpdate`) VALUES (0,1,2275,@idRole,1,'2016-05-26 18:09:57');
INSERT INTO `role_privileges` (`whetherOverrideAllowed`,`granted`,`featurePrivilegeId`,`roleId`,`lastUpdatedBy`,`lastUpdate`) VALUES (0,1,2459,@idRole,1,'2016-05-26 18:09:57');
INSERT INTO `role_privileges` (`whetherOverrideAllowed`,`granted`,`featurePrivilegeId`,`roleId`,`lastUpdatedBy`,`lastUpdate`) VALUES (0,1,2746,@idRole,1,'2016-05-26 18:09:57');
INSERT INTO `role_privileges` (`whetherOverrideAllowed`,`granted`,`featurePrivilegeId`,`roleId`,`lastUpdatedBy`,`lastUpdate`) VALUES (0,1,2633,@idRole,1,'2016-05-26 18:09:57');
INSERT INTO `role_privileges` (`whetherOverrideAllowed`,`granted`,`featurePrivilegeId`,`roleId`,`lastUpdatedBy`,`lastUpdate`) VALUES (0,1,2428,@idRole,1,'2016-05-26 18:09:57');
INSERT INTO `role_privileges` (`whetherOverrideAllowed`,`granted`,`featurePrivilegeId`,`roleId`,`lastUpdatedBy`,`lastUpdate`) VALUES (0,1,2429,@idRole,1,'2016-05-26 18:09:57');
INSERT INTO `role_privileges` (`whetherOverrideAllowed`,`granted`,`featurePrivilegeId`,`roleId`,`lastUpdatedBy`,`lastUpdate`) VALUES (0,1,2373,@idRole,1,'2016-05-26 18:09:57');
INSERT INTO `role_privileges` (`whetherOverrideAllowed`,`granted`,`featurePrivilegeId`,`roleId`,`lastUpdatedBy`,`lastUpdate`) VALUES (0,1,2370,@idRole,1,'2016-05-26 18:09:57');
INSERT INTO `role_privileges` (`whetherOverrideAllowed`,`granted`,`featurePrivilegeId`,`roleId`,`lastUpdatedBy`,`lastUpdate`) VALUES (0,1,2318,@idRole,1,'2016-05-26 18:09:57');
INSERT INTO `role_privileges` (`whetherOverrideAllowed`,`granted`,`featurePrivilegeId`,`roleId`,`lastUpdatedBy`,`lastUpdate`) VALUES (0,1,2317,@idRole,1,'2016-05-26 18:09:57');
INSERT INTO `role_privileges` (`whetherOverrideAllowed`,`granted`,`featurePrivilegeId`,`roleId`,`lastUpdatedBy`,`lastUpdate`) VALUES (0,1,2570,@idRole,1,'2016-05-26 18:09:57');
INSERT INTO `role_privileges` (`whetherOverrideAllowed`,`granted`,`featurePrivilegeId`,`roleId`,`lastUpdatedBy`,`lastUpdate`) VALUES (0,1,2438,@idRole,1,'2016-05-26 18:09:57');
INSERT INTO `role_privileges` (`whetherOverrideAllowed`,`granted`,`featurePrivilegeId`,`roleId`,`lastUpdatedBy`,`lastUpdate`) VALUES (0,1,2420,@idRole,1,'2016-05-26 18:09:57');
INSERT INTO `role_privileges` (`whetherOverrideAllowed`,`granted`,`featurePrivilegeId`,`roleId`,`lastUpdatedBy`,`lastUpdate`) VALUES (0,1,2634,@idRole,1,'2016-05-26 18:09:57');
INSERT INTO `role_privileges` (`whetherOverrideAllowed`,`granted`,`featurePrivilegeId`,`roleId`,`lastUpdatedBy`,`lastUpdate`) VALUES (0,1,2292,@idRole,1,'2016-05-26 18:09:57');
INSERT INTO `role_privileges` (`whetherOverrideAllowed`,`granted`,`featurePrivilegeId`,`roleId`,`lastUpdatedBy`,`lastUpdate`) VALUES (0,1,2636,@idRole,1,'2016-05-26 18:09:57');
INSERT INTO `role_privileges` (`whetherOverrideAllowed`,`granted`,`featurePrivilegeId`,`roleId`,`lastUpdatedBy`,`lastUpdate`) VALUES (0,1,2630,@idRole,1,'2016-05-26 18:09:57');
INSERT INTO `role_privileges` (`whetherOverrideAllowed`,`granted`,`featurePrivilegeId`,`roleId`,`lastUpdatedBy`,`lastUpdate`) VALUES (0,1,2451,@idRole,1,'2016-05-26 18:09:57');
INSERT INTO `role_privileges` (`whetherOverrideAllowed`,`granted`,`featurePrivilegeId`,`roleId`,`lastUpdatedBy`,`lastUpdate`) VALUES (0,1,2367,@idRole,1,'2016-05-26 18:09:57');
INSERT INTO `role_privileges` (`whetherOverrideAllowed`,`granted`,`featurePrivilegeId`,`roleId`,`lastUpdatedBy`,`lastUpdate`) VALUES (0,1,2368,@idRole,1,'2016-05-26 18:09:57');
INSERT INTO `role_privileges` (`whetherOverrideAllowed`,`granted`,`featurePrivilegeId`,`roleId`,`lastUpdatedBy`,`lastUpdate`) VALUES (0,1,2447,@idRole,1,'2016-05-26 18:09:57');
INSERT INTO `role_privileges` (`whetherOverrideAllowed`,`granted`,`featurePrivilegeId`,`roleId`,`lastUpdatedBy`,`lastUpdate`) VALUES (0,1,2569,@idRole,1,'2016-05-26 18:09:57');
INSERT INTO `role_privileges` (`whetherOverrideAllowed`,`granted`,`featurePrivilegeId`,`roleId`,`lastUpdatedBy`,`lastUpdate`) VALUES (0,1,2273,@idRole,1,'2016-05-26 18:09:57');
INSERT INTO `role_privileges` (`whetherOverrideAllowed`,`granted`,`featurePrivilegeId`,`roleId`,`lastUpdatedBy`,`lastUpdate`) VALUES (0,1,2602,@idRole,1,'2016-05-26 18:09:57');
INSERT INTO `role_privileges` (`whetherOverrideAllowed`,`granted`,`featurePrivilegeId`,`roleId`,`lastUpdatedBy`,`lastUpdate`) VALUES (0,1,2421,@idRole,1,'2016-05-26 18:09:57');
INSERT INTO `role_privileges` (`whetherOverrideAllowed`,`granted`,`featurePrivilegeId`,`roleId`,`lastUpdatedBy`,`lastUpdate`) VALUES (0,1,2442,@idRole,1,'2016-05-26 18:09:57');
INSERT INTO `role_privileges` (`whetherOverrideAllowed`,`granted`,`featurePrivilegeId`,`roleId`,`lastUpdatedBy`,`lastUpdate`) VALUES (0,1,2641,@idRole,1,'2016-05-26 18:09:57');
INSERT INTO `role_privileges` (`whetherOverrideAllowed`,`granted`,`featurePrivilegeId`,`roleId`,`lastUpdatedBy`,`lastUpdate`) VALUES (0,1,2460,@idRole,1,'2016-05-26 18:09:57');
INSERT INTO `role_privileges` (`whetherOverrideAllowed`,`granted`,`featurePrivilegeId`,`roleId`,`lastUpdatedBy`,`lastUpdate`) VALUES (0,1,2640,@idRole,1,'2016-05-26 18:09:57');
INSERT INTO `role_privileges` (`whetherOverrideAllowed`,`granted`,`featurePrivilegeId`,`roleId`,`lastUpdatedBy`,`lastUpdate`) VALUES (0,1,2294,@idRole,1,'2016-05-26 18:09:57');
INSERT INTO `role_privileges` (`whetherOverrideAllowed`,`granted`,`featurePrivilegeId`,`roleId`,`lastUpdatedBy`,`lastUpdate`) VALUES (0,1,2448,@idRole,1,'2016-05-26 18:09:57');
INSERT INTO `role_privileges` (`whetherOverrideAllowed`,`granted`,`featurePrivilegeId`,`roleId`,`lastUpdatedBy`,`lastUpdate`) VALUES (0,1,2440,@idRole,1,'2016-05-26 18:09:57');
INSERT INTO `role_privileges` (`whetherOverrideAllowed`,`granted`,`featurePrivilegeId`,`roleId`,`lastUpdatedBy`,`lastUpdate`) VALUES (0,1,2745,@idRole,1,'2016-05-26 18:09:57');
INSERT INTO `role_privileges` (`whetherOverrideAllowed`,`granted`,`featurePrivilegeId`,`roleId`,`lastUpdatedBy`,`lastUpdate`) VALUES (0,1,2631,@idRole,1,'2016-05-26 18:09:57');
INSERT INTO `role_privileges` (`whetherOverrideAllowed`,`granted`,`featurePrivilegeId`,`roleId`,`lastUpdatedBy`,`lastUpdate`) VALUES (0,1,2380,@idRole,1,'2016-05-26 18:09:57');
INSERT INTO `role_privileges` (`whetherOverrideAllowed`,`granted`,`featurePrivilegeId`,`roleId`,`lastUpdatedBy`,`lastUpdate`) VALUES (0,1,2430,@idRole,1,'2016-05-26 18:09:57');
INSERT INTO `role_privileges` (`whetherOverrideAllowed`,`granted`,`featurePrivilegeId`,`roleId`,`lastUpdatedBy`,`lastUpdate`) VALUES (0,1,2297,@idRole,1,'2016-05-26 18:09:57');
INSERT INTO `role_privileges` (`whetherOverrideAllowed`,`granted`,`featurePrivilegeId`,`roleId`,`lastUpdatedBy`,`lastUpdate`) VALUES (0,1,2356,@idRole,1,'2016-05-26 18:09:57');
INSERT INTO `role_privileges` (`whetherOverrideAllowed`,`granted`,`featurePrivilegeId`,`roleId`,`lastUpdatedBy`,`lastUpdate`) VALUES (0,1,2462,@idRole,1,'2016-05-26 18:09:57');
INSERT INTO `role_privileges` (`whetherOverrideAllowed`,`granted`,`featurePrivilegeId`,`roleId`,`lastUpdatedBy`,`lastUpdate`) VALUES (0,1,2454,@idRole,1,'2016-05-26 18:09:57');
INSERT INTO `role_privileges` (`whetherOverrideAllowed`,`granted`,`featurePrivilegeId`,`roleId`,`lastUpdatedBy`,`lastUpdate`) VALUES (0,1,2452,@idRole,1,'2016-05-26 18:09:57');
INSERT INTO `role_privileges` (`whetherOverrideAllowed`,`granted`,`featurePrivilegeId`,`roleId`,`lastUpdatedBy`,`lastUpdate`) VALUES (0,1,2274,@idRole,1,'2016-05-26 18:09:57');
INSERT INTO `role_privileges` (`whetherOverrideAllowed`,`granted`,`featurePrivilegeId`,`roleId`,`lastUpdatedBy`,`lastUpdate`) VALUES (0,1,2364,@idRole,1,'2016-05-26 18:09:57');
INSERT INTO `role_privileges` (`whetherOverrideAllowed`,`granted`,`featurePrivilegeId`,`roleId`,`lastUpdatedBy`,`lastUpdate`) VALUES (0,1,2431,@idRole,1,'2016-05-26 18:09:57');
INSERT INTO `role_privileges` (`whetherOverrideAllowed`,`granted`,`featurePrivilegeId`,`roleId`,`lastUpdatedBy`,`lastUpdate`) VALUES (0,1,2456,@idRole,1,'2016-05-26 18:09:57');
INSERT INTO `role_privileges` (`whetherOverrideAllowed`,`granted`,`featurePrivilegeId`,`roleId`,`lastUpdatedBy`,`lastUpdate`) VALUES (0,1,2366,@idRole,1,'2016-05-26 18:09:57');
INSERT INTO `role_privileges` (`whetherOverrideAllowed`,`granted`,`featurePrivilegeId`,`roleId`,`lastUpdatedBy`,`lastUpdate`) VALUES (0,1,2358,@idRole,1,'2016-05-26 18:09:57');
INSERT INTO `role_privileges` (`whetherOverrideAllowed`,`granted`,`featurePrivilegeId`,`roleId`,`lastUpdatedBy`,`lastUpdate`) VALUES (0,1,2419,@idRole,1,'2016-05-26 18:09:57');
INSERT INTO `role_privileges` (`whetherOverrideAllowed`,`granted`,`featurePrivilegeId`,`roleId`,`lastUpdatedBy`,`lastUpdate`) VALUES (0,1,2269,@idRole,1,'2016-05-26 18:09:57');
INSERT INTO `role_privileges` (`whetherOverrideAllowed`,`granted`,`featurePrivilegeId`,`roleId`,`lastUpdatedBy`,`lastUpdate`) VALUES (0,1,2293,@idRole,1,'2016-05-26 18:09:57');
INSERT INTO `role_privileges` (`whetherOverrideAllowed`,`granted`,`featurePrivilegeId`,`roleId`,`lastUpdatedBy`,`lastUpdate`) VALUES (0,1,2313,@idRole,1,'2016-05-26 18:09:57');
INSERT INTO `role_privileges` (`whetherOverrideAllowed`,`granted`,`featurePrivilegeId`,`roleId`,`lastUpdatedBy`,`lastUpdate`) VALUES (0,1,2427,@idRole,1,'2016-05-26 18:09:57');
INSERT INTO `role_privileges` (`whetherOverrideAllowed`,`granted`,`featurePrivilegeId`,`roleId`,`lastUpdatedBy`,`lastUpdate`) VALUES (0,1,2436,@idRole,1,'2016-05-26 18:09:57');
INSERT INTO `role_privileges` (`whetherOverrideAllowed`,`granted`,`featurePrivilegeId`,`roleId`,`lastUpdatedBy`,`lastUpdate`) VALUES (0,1,2306,@idRole,1,'2016-05-26 18:09:57');
INSERT INTO `role_privileges` (`whetherOverrideAllowed`,`granted`,`featurePrivilegeId`,`roleId`,`lastUpdatedBy`,`lastUpdate`) VALUES (0,1,2345,@idRole,1,'2016-05-26 18:09:57');
INSERT INTO `role_privileges` (`whetherOverrideAllowed`,`granted`,`featurePrivilegeId`,`roleId`,`lastUpdatedBy`,`lastUpdate`) VALUES (0,1,2279,@idRole,1,'2016-05-26 18:09:57');
INSERT INTO `role_privileges` (`whetherOverrideAllowed`,`granted`,`featurePrivilegeId`,`roleId`,`lastUpdatedBy`,`lastUpdate`) VALUES (0,1,2363,@idRole,1,'2016-05-26 18:09:57');
INSERT INTO `role_privileges` (`whetherOverrideAllowed`,`granted`,`featurePrivilegeId`,`roleId`,`lastUpdatedBy`,`lastUpdate`) VALUES (0,1,2744,@idRole,1,'2016-05-26 18:09:57');
INSERT INTO `role_privileges` (`whetherOverrideAllowed`,`granted`,`featurePrivilegeId`,`roleId`,`lastUpdatedBy`,`lastUpdate`) VALUES (0,1,2365,@idRole,1,'2016-05-26 18:09:57');
INSERT INTO `role_privileges` (`whetherOverrideAllowed`,`granted`,`featurePrivilegeId`,`roleId`,`lastUpdatedBy`,`lastUpdate`) VALUES (0,1,2423,@idRole,1,'2016-05-26 18:09:57');
INSERT INTO `role_privileges` (`whetherOverrideAllowed`,`granted`,`featurePrivilegeId`,`roleId`,`lastUpdatedBy`,`lastUpdate`) VALUES (0,1,2453,@idRole,1,'2016-05-26 18:09:57');
INSERT INTO `role_privileges` (`whetherOverrideAllowed`,`granted`,`featurePrivilegeId`,`roleId`,`lastUpdatedBy`,`lastUpdate`) VALUES (0,1,2289,@idRole,1,'2016-05-26 18:09:57');
INSERT INTO `role_privileges` (`whetherOverrideAllowed`,`granted`,`featurePrivilegeId`,`roleId`,`lastUpdatedBy`,`lastUpdate`) VALUES (0,1,2422,@idRole,1,'2016-05-26 18:09:57');
INSERT INTO `role_privileges` (`whetherOverrideAllowed`,`granted`,`featurePrivilegeId`,`roleId`,`lastUpdatedBy`,`lastUpdate`) VALUES (0,1,2445,@idRole,1,'2016-05-26 18:09:57');
INSERT INTO `role_privileges` (`whetherOverrideAllowed`,`granted`,`featurePrivilegeId`,`roleId`,`lastUpdatedBy`,`lastUpdate`) VALUES (0,1,2315,@idRole,1,'2016-05-26 18:09:57');
INSERT INTO `role_privileges` (`whetherOverrideAllowed`,`granted`,`featurePrivilegeId`,`roleId`,`lastUpdatedBy`,`lastUpdate`) VALUES (0,1,2458,@idRole,1,'2016-05-26 18:09:57');
INSERT INTO `role_privileges` (`whetherOverrideAllowed`,`granted`,`featurePrivilegeId`,`roleId`,`lastUpdatedBy`,`lastUpdate`) VALUES (0,1,2295,@idRole,1,'2016-05-26 18:09:57');
INSERT INTO `role_privileges` (`whetherOverrideAllowed`,`granted`,`featurePrivilegeId`,`roleId`,`lastUpdatedBy`,`lastUpdate`) VALUES (0,1,2291,@idRole,1,'2016-05-26 18:09:57');
INSERT INTO `role_privileges` (`whetherOverrideAllowed`,`granted`,`featurePrivilegeId`,`roleId`,`lastUpdatedBy`,`lastUpdate`) VALUES (0,1,2357,@idRole,1,'2016-05-26 18:09:57');
INSERT INTO `role_privileges` (`whetherOverrideAllowed`,`granted`,`featurePrivilegeId`,`roleId`,`lastUpdatedBy`,`lastUpdate`) VALUES (0,1,2571,@idRole,1,'2016-05-26 18:09:57');
INSERT INTO `role_privileges` (`whetherOverrideAllowed`,`granted`,`featurePrivilegeId`,`roleId`,`lastUpdatedBy`,`lastUpdate`) VALUES (0,1,2371,@idRole,1,'2016-05-26 18:09:57');
INSERT INTO `role_privileges` (`whetherOverrideAllowed`,`granted`,`featurePrivilegeId`,`roleId`,`lastUpdatedBy`,`lastUpdate`) VALUES (0,1,2362,@idRole,1,'2016-05-26 18:09:57');
INSERT INTO `role_privileges` (`whetherOverrideAllowed`,`granted`,`featurePrivilegeId`,`roleId`,`lastUpdatedBy`,`lastUpdate`) VALUES (0,1,2301,@idRole,1,'2016-05-26 18:09:57');
INSERT INTO `role_privileges` (`whetherOverrideAllowed`,`granted`,`featurePrivilegeId`,`roleId`,`lastUpdatedBy`,`lastUpdate`) VALUES (0,1,2439,@idRole,1,'2016-05-26 18:09:57');
INSERT INTO `role_privileges` (`whetherOverrideAllowed`,`granted`,`featurePrivilegeId`,`roleId`,`lastUpdatedBy`,`lastUpdate`) VALUES (0,1,2743,@idRole,1,'2016-05-26 18:09:57');
INSERT INTO `role_privileges` (`whetherOverrideAllowed`,`granted`,`featurePrivilegeId`,`roleId`,`lastUpdatedBy`,`lastUpdate`) VALUES (0,1,2424,@idRole,1,'2016-05-26 18:09:57');
INSERT INTO `role_privileges` (`whetherOverrideAllowed`,`granted`,`featurePrivilegeId`,`roleId`,`lastUpdatedBy`,`lastUpdate`) VALUES (0,1,2290,@idRole,1,'2016-05-26 18:09:57');
INSERT INTO `role_privileges` (`whetherOverrideAllowed`,`granted`,`featurePrivilegeId`,`roleId`,`lastUpdatedBy`,`lastUpdate`) VALUES (0,1,2455,@idRole,1,'2016-05-26 18:09:57');
INSERT INTO `role_privileges` (`whetherOverrideAllowed`,`granted`,`featurePrivilegeId`,`roleId`,`lastUpdatedBy`,`lastUpdate`) VALUES (0,1,2276,@idRole,1,'2016-05-26 18:09:57');
INSERT INTO `role_privileges` (`whetherOverrideAllowed`,`granted`,`featurePrivilegeId`,`roleId`,`lastUpdatedBy`,`lastUpdate`) VALUES (0,1,2638,@idRole,1,'2016-05-26 18:09:57');
INSERT INTO `role_privileges` (`whetherOverrideAllowed`,`granted`,`featurePrivilegeId`,`roleId`,`lastUpdatedBy`,`lastUpdate`) VALUES (0,1,2384,@idRole,1,'2016-05-26 18:09:57');
INSERT INTO `role_privileges` (`whetherOverrideAllowed`,`granted`,`featurePrivilegeId`,`roleId`,`lastUpdatedBy`,`lastUpdate`) VALUES (0,1,2383,@idRole,1,'2016-05-26 18:09:57');
INSERT INTO `role_privileges` (`whetherOverrideAllowed`,`granted`,`featurePrivilegeId`,`roleId`,`lastUpdatedBy`,`lastUpdate`) VALUES (0,1,2449,@idRole,1,'2016-05-26 18:09:57');
INSERT INTO `role_privileges` (`whetherOverrideAllowed`,`granted`,`featurePrivilegeId`,`roleId`,`lastUpdatedBy`,`lastUpdate`) VALUES (0,1,2268,@idRole,1,'2016-05-26 18:09:57');
INSERT INTO `role_privileges` (`whetherOverrideAllowed`,`granted`,`featurePrivilegeId`,`roleId`,`lastUpdatedBy`,`lastUpdate`) VALUES (0,1,2369,@idRole,1,'2016-05-26 18:09:57');
INSERT INTO `role_privileges` (`whetherOverrideAllowed`,`granted`,`featurePrivilegeId`,`roleId`,`lastUpdatedBy`,`lastUpdate`) VALUES (0,1,2300,@idRole,1,'2016-05-26 18:09:57');
INSERT INTO `role_privileges` (`whetherOverrideAllowed`,`granted`,`featurePrivilegeId`,`roleId`,`lastUpdatedBy`,`lastUpdate`) VALUES (0,1,2450,@idRole,1,'2016-05-26 18:09:57');
INSERT INTO `role_privileges` (`whetherOverrideAllowed`,`granted`,`featurePrivilegeId`,`roleId`,`lastUpdatedBy`,`lastUpdate`) VALUES (0,1,2461,@idRole,1,'2016-05-26 18:09:57');
INSERT INTO `role_privileges` (`whetherOverrideAllowed`,`granted`,`featurePrivilegeId`,`roleId`,`lastUpdatedBy`,`lastUpdate`) VALUES (0,1,2288,@idRole,1,'2016-05-26 18:09:57');
INSERT INTO `role_privileges` (`whetherOverrideAllowed`,`granted`,`featurePrivilegeId`,`roleId`,`lastUpdatedBy`,`lastUpdate`) VALUES (0,1,2463,@idRole,1,'2016-05-26 18:09:57');
INSERT INTO `role_privileges` (`whetherOverrideAllowed`,`granted`,`featurePrivilegeId`,`roleId`,`lastUpdatedBy`,`lastUpdate`) VALUES (0,1,2437,@idRole,1,'2016-05-26 18:09:57');
INSERT INTO `role_privileges` (`whetherOverrideAllowed`,`granted`,`featurePrivilegeId`,`roleId`,`lastUpdatedBy`,`lastUpdate`) VALUES (0,1,2280,@idRole,1,'2016-05-26 18:09:57');
INSERT INTO `role_privileges` (`whetherOverrideAllowed`,`granted`,`featurePrivilegeId`,`roleId`,`lastUpdatedBy`,`lastUpdate`) VALUES (0,1,2305,@idRole,1,'2016-05-26 18:09:57');
INSERT INTO `role_privileges` (`whetherOverrideAllowed`,`granted`,`featurePrivilegeId`,`roleId`,`lastUpdatedBy`,`lastUpdate`) VALUES (0,1,2601,@idRole,1,'2016-05-26 18:09:57');
INSERT INTO `role_privileges` (`whetherOverrideAllowed`,`granted`,`featurePrivilegeId`,`roleId`,`lastUpdatedBy`,`lastUpdate`) VALUES (0,1,2271,@idRole,1,'2016-05-26 18:09:57');
INSERT INTO `role_privileges` (`whetherOverrideAllowed`,`granted`,`featurePrivilegeId`,`roleId`,`lastUpdatedBy`,`lastUpdate`) VALUES (0,1,2314,@idRole,1,'2016-05-26 18:09:57');
INSERT INTO `role_privileges` (`whetherOverrideAllowed`,`granted`,`featurePrivilegeId`,`roleId`,`lastUpdatedBy`,`lastUpdate`) VALUES (0,1,2425,@idRole,1,'2016-05-26 18:09:57');
INSERT INTO `role_privileges` (`whetherOverrideAllowed`,`granted`,`featurePrivilegeId`,`roleId`,`lastUpdatedBy`,`lastUpdate`) VALUES (0,1,2435,@idRole,1,'2016-05-26 18:09:57');
INSERT INTO `role_privileges` (`whetherOverrideAllowed`,`granted`,`featurePrivilegeId`,`roleId`,`lastUpdatedBy`,`lastUpdate`) VALUES (0,1,2426,@idRole,1,'2016-05-26 18:09:57');
INSERT INTO `role_privileges` (`whetherOverrideAllowed`,`granted`,`featurePrivilegeId`,`roleId`,`lastUpdatedBy`,`lastUpdate`) VALUES (0,1,2639,@idRole,1,'2016-05-26 18:09:57');
INSERT INTO `role_privileges` (`whetherOverrideAllowed`,`granted`,`featurePrivilegeId`,`roleId`,`lastUpdatedBy`,`lastUpdate`) VALUES (0,1,2599,@idRole,1,'2016-05-26 18:09:57');
INSERT INTO `role_privileges` (`whetherOverrideAllowed`,`granted`,`featurePrivilegeId`,`roleId`,`lastUpdatedBy`,`lastUpdate`) VALUES (0,1,2296,@idRole,1,'2016-05-26 18:09:57');
INSERT INTO `role_privileges` (`whetherOverrideAllowed`,`granted`,`featurePrivilegeId`,`roleId`,`lastUpdatedBy`,`lastUpdate`) VALUES (0,1,2418,@idRole,1,'2016-05-26 18:09:57');
INSERT INTO `role_privileges` (`whetherOverrideAllowed`,`granted`,`featurePrivilegeId`,`roleId`,`lastUpdatedBy`,`lastUpdate`) VALUES (0,1,2281,@idRole,1,'2016-05-26 18:09:57');
INSERT INTO `role_privileges` (`whetherOverrideAllowed`,`granted`,`featurePrivilegeId`,`roleId`,`lastUpdatedBy`,`lastUpdate`) VALUES (0,1,2308,@idRole,1,'2016-05-26 18:09:57');
INSERT INTO `role_privileges` (`whetherOverrideAllowed`,`granted`,`featurePrivilegeId`,`roleId`,`lastUpdatedBy`,`lastUpdate`) VALUES (0,1,2637,@idRole,1,'2016-05-26 18:09:57');
INSERT INTO `role_privileges` (`whetherOverrideAllowed`,`granted`,`featurePrivilegeId`,`roleId`,`lastUpdatedBy`,`lastUpdate`) VALUES (0,1,2600,@idRole,1,'2016-05-26 18:09:57');
INSERT INTO `role_privileges` (`whetherOverrideAllowed`,`granted`,`featurePrivilegeId`,`roleId`,`lastUpdatedBy`,`lastUpdate`) VALUES (0,1,2433,@idRole,1,'2016-05-26 18:09:57');
INSERT INTO `role_privileges` (`whetherOverrideAllowed`,`granted`,`featurePrivilegeId`,`roleId`,`lastUpdatedBy`,`lastUpdate`) VALUES (0,1,2319,@idRole,1,'2016-05-26 18:09:57');
INSERT INTO `role_privileges` (`whetherOverrideAllowed`,`granted`,`featurePrivilegeId`,`roleId`,`lastUpdatedBy`,`lastUpdate`) VALUES (0,1,2359,@idRole,1,'2016-05-26 18:09:57');
INSERT INTO `role_privileges` (`whetherOverrideAllowed`,`granted`,`featurePrivilegeId`,`roleId`,`lastUpdatedBy`,`lastUpdate`) VALUES (0,1,2277,@idRole,1,'2016-05-26 18:09:57');
INSERT INTO `role_privileges` (`whetherOverrideAllowed`,`granted`,`featurePrivilegeId`,`roleId`,`lastUpdatedBy`,`lastUpdate`) VALUES (0,1,2432,@idRole,1,'2016-05-26 18:09:57');
INSERT INTO `role_privileges` (`whetherOverrideAllowed`,`granted`,`featurePrivilegeId`,`roleId`,`lastUpdatedBy`,`lastUpdate`) VALUES (0,1,2446,@idRole,1,'2016-05-26 18:09:57');
INSERT INTO `role_privileges` (`whetherOverrideAllowed`,`granted`,`featurePrivilegeId`,`roleId`,`lastUpdatedBy`,`lastUpdate`) VALUES (0,1,2304,@idRole,1,'2016-05-26 18:09:57');
INSERT INTO `role_privileges` (`whetherOverrideAllowed`,`granted`,`featurePrivilegeId`,`roleId`,`lastUpdatedBy`,`lastUpdate`) VALUES (0,1,2742,@idRole,1,'2016-05-26 18:09:57');
INSERT INTO `role_privileges` (`whetherOverrideAllowed`,`granted`,`featurePrivilegeId`,`roleId`,`lastUpdatedBy`,`lastUpdate`) VALUES (0,1,2309,@idRole,1,'2016-05-26 18:09:57');
INSERT INTO `role_privileges` (`whetherOverrideAllowed`,`granted`,`featurePrivilegeId`,`roleId`,`lastUpdatedBy`,`lastUpdate`) VALUES (0,1,2434,@idRole,1,'2016-05-26 18:09:57');
INSERT INTO `role_privileges` (`whetherOverrideAllowed`,`granted`,`featurePrivilegeId`,`roleId`,`lastUpdatedBy`,`lastUpdate`) VALUES (0,1,2307,@idRole,1,'2016-05-26 18:09:57');
INSERT INTO `role_privileges` (`whetherOverrideAllowed`,`granted`,`featurePrivilegeId`,`roleId`,`lastUpdatedBy`,`lastUpdate`) VALUES (0,1,2278,@idRole,1,'2016-05-26 18:09:57');
INSERT INTO `role_privileges` (`whetherOverrideAllowed`,`granted`,`featurePrivilegeId`,`roleId`,`lastUpdatedBy`,`lastUpdate`) VALUES (0,1,2382,@idRole,1,'2016-05-26 18:09:57');
INSERT INTO `role_privileges` (`whetherOverrideAllowed`,`granted`,`featurePrivilegeId`,`roleId`,`lastUpdatedBy`,`lastUpdate`) VALUES (0,1,2632,@idRole,1,'2016-05-26 18:09:57');
INSERT INTO `role_privileges` (`whetherOverrideAllowed`,`granted`,`featurePrivilegeId`,`roleId`,`lastUpdatedBy`,`lastUpdate`) VALUES (0,1,2457,@idRole,1,'2016-05-26 18:09:57');
INSERT INTO `role_privileges` (`whetherOverrideAllowed`,`granted`,`featurePrivilegeId`,`roleId`,`lastUpdatedBy`,`lastUpdate`) VALUES (0,1,2344,@idRole,1,'2016-05-26 18:09:57');
INSERT INTO `role_privileges` (`whetherOverrideAllowed`,`granted`,`featurePrivilegeId`,`roleId`,`lastUpdatedBy`,`lastUpdate`) VALUES (0,1,2270,@idRole,1,'2016-05-26 18:09:57');
INSERT INTO `role_privileges` (`whetherOverrideAllowed`,`granted`,`featurePrivilegeId`,`roleId`,`lastUpdatedBy`,`lastUpdate`) VALUES (0,1,2310,@idRole,1,'2016-05-26 18:09:57');
INSERT INTO `role_privileges` (`whetherOverrideAllowed`,`granted`,`featurePrivilegeId`,`roleId`,`lastUpdatedBy`,`lastUpdate`) VALUES (0,1,2311,@idRole,1,'2016-05-26 18:09:57');
INSERT INTO `role_privileges` (`whetherOverrideAllowed`,`granted`,`featurePrivilegeId`,`roleId`,`lastUpdatedBy`,`lastUpdate`) VALUES (0,1,2361,@idRole,1,'2016-05-26 18:09:57');
INSERT INTO `role_privileges` (`whetherOverrideAllowed`,`granted`,`featurePrivilegeId`,`roleId`,`lastUpdatedBy`,`lastUpdate`) VALUES (0,1,2372,@idRole,1,'2016-05-26 18:09:57');
INSERT INTO `role_privileges` (`whetherOverrideAllowed`,`granted`,`featurePrivilegeId`,`roleId`,`lastUpdatedBy`,`lastUpdate`) VALUES (0,1,2381,@idRole,1,'2016-05-26 18:09:57');
INSERT INTO `role_privileges` (`whetherOverrideAllowed`,`granted`,`featurePrivilegeId`,`roleId`,`lastUpdatedBy`,`lastUpdate`) VALUES (0,1,2572,@idRole,1,'2016-05-26 18:09:57');
INSERT INTO `role_privileges` (`whetherOverrideAllowed`,`granted`,`featurePrivilegeId`,`roleId`,`lastUpdatedBy`,`lastUpdate`) VALUES (0,1,2316,@idRole,1,'2016-05-26 18:09:57');
INSERT INTO `role_privileges` (`whetherOverrideAllowed`,`granted`,`featurePrivilegeId`,`roleId`,`lastUpdatedBy`,`lastUpdate`) VALUES (0,1,2272,@idRole,1,'2016-05-26 18:09:57');

/************** Education details: Result Status  *********************/
INSERT INTO result_status (itemCode,itemValue, lastUpdate, lastUpdatedBy)  VALUES ('Fail','Fail','2017-01-04 12:00:00',1);
INSERT INTO result_status (itemCode,itemValue, lastUpdate, lastUpdatedBy)  VALUES ('Result Awaiting','Result Awaiting','2017-01-04 12:00:00',1);
INSERT INTO result_status (itemCode,itemValue, lastUpdate, lastUpdatedBy)  VALUES ('Pursuing','Pursuing','2017-01-04 12:00:00',1);

/************** Education details: Study Mode  *********************/
INSERT INTO study_mode (itemCode,itemValue, lastUpdate, lastUpdatedBy)  VALUES ('Regular','Regular','2017-01-04 12:00:00',1);
INSERT INTO study_mode (itemCode,itemValue, lastUpdate, lastUpdatedBy)  VALUES ('Distance Education','Distance Education','2017-01-04 12:00:00',1);

-- Employee Leave Request Related Changes Committed
insert  into `request_types`(`id`,`serviceRequestGroup`,`whetherDeleted`,`requestTypeCode`,`requestTypeName`,`lastUpdatedBy`,`lastUpdate`,`type`,`feeRelatedCategory`) 
values (47,'TRANSFER','\0','EMPL','Employee Leave',1,'2014-08-01 07:13:42','COMMON',NULL);
UPDATE `request_type_categories` SET `requestTypeId`='47' WHERE `id`='18';

insert  into `request_types`(`id`,`serviceRequestGroup`,`whetherDeleted`,`requestTypeCode`,`requestTypeName`,`lastUpdatedBy`,`lastUpdate`,`type`,`feeRelatedCategory`) 
values (49,'TRANSFER','\0','STDTRAN','Student Transfer',1,'2018-09-25 07:13:42','COMMON',NULL);
INSERT INTO `request_type_categories` (`id`, `serviceRequestCategory`, `whetherDeleted`, `lastUpdatedBy`, `lastUpdate`, `requestTypeId`) 
VALUES ('57', 'STUDENT_REQUEST', 0, '1', '2018-09-25 17:46:09', '49');

INSERT INTO `request_types` (`id`, `serviceRequestGroup`, `whetherDeleted`, `requestTypeCode`, `requestTypeName`, `lastUpdatedBy`, `lastUpdate`, `type`)
VALUES ('50', 'TRANSFER', 0, 'SCHLVR', 'School Leaving', '1', '2018-11-14 15:46:47', 'COMMON');
INSERT INTO `request_type_categories` (`id`, `serviceRequestCategory`, `whetherDeleted`, `lastUpdatedBy`, `lastUpdate`, `requestTypeId`) 
VALUES ('58', 'STUDENT_REQUEST', 0, '1', '2018-11-14 13:16:09', '50');

INSERT INTO `request_types` (`id`, `serviceRequestGroup`, `whetherDeleted`, `requestTypeCode`, `requestTypeName`, `lastUpdatedBy`, `lastUpdate`, `type`)
VALUES ('51', 'CERTIFICATE', 0, 'COMMUNITY', 'Community', '1', '2018-11-14 15:46:47', 'COMMON');
INSERT INTO `request_types` (`id`, `serviceRequestGroup`, `whetherDeleted`, `requestTypeCode`, `requestTypeName`, `lastUpdatedBy`, `lastUpdate`, `type`)
VALUES ('52', 'CERTIFICATE', 0, 'COURSES', 'Courses', '1', '2018-11-14 15:46:47', 'COMMON');
INSERT INTO `request_types` (`id`, `serviceRequestGroup`, `whetherDeleted`, `requestTypeCode`, `requestTypeName`, `lastUpdatedBy`, `lastUpdate`, `type`)
VALUES ('53', 'CERTIFICATE', 0, 'OTHER', 'Other', '1', '2018-11-14 15:46:47', 'COMMON');
INSERT INTO `request_types` (`id`, `serviceRequestGroup`, `whetherDeleted`, `requestTypeCode`, `requestTypeName`, `lastUpdatedBy`, `lastUpdate`, `type`)
VALUES ('54', 'CERTIFICATE', 0, 'PROGRAM', 'Program', '1', '2018-11-14 15:46:47', 'COMMON');
INSERT INTO `request_types` (`id`, `serviceRequestGroup`, `whetherDeleted`, `requestTypeCode`, `requestTypeName`, `lastUpdatedBy`, `lastUpdate`, `type`)
VALUES ('55', 'GENERAL', 0, 'APFRM', 'Program', '1', '2018-12-28 14:55:27', 'COMMON');
INSERT INTO `request_types` (`id`, `serviceRequestGroup`, `whetherDeleted`, `requestTypeCode`, `requestTypeName`, `lastUpdatedBy`, `lastUpdate`, `type`)
VALUES ('56', 'GENERAL', 0, 'MENREQ', 'Mentor Request', '1', '2018-12-28 14:55:27', 'COMMON');
INSERT INTO `request_types` (`id`, `serviceRequestGroup`, `whetherDeleted`, `requestTypeCode`, `requestTypeName`, `lastUpdatedBy`, `lastUpdate`, `type`)
VALUES ('57', 'GENERAL', 0, 'TEXTBOOK', 'Text Book', '1', '2018-12-28 14:55:27', 'COMMON');




/************** Grade Master: Exam Result Status  *********************/
INSERT INTO exam_result_status (itemCode,itemValue, lastUpdate, lastUpdatedBy)  VALUES ('PASS','Pass','2018-03-14 12:00:00',1);
INSERT INTO exam_result_status (itemCode,itemValue, lastUpdate, lastUpdatedBy)  VALUES ('FAIL','Fail','2018-03-14 12:00:00',1);

-- Parent Poratl Inserts --

insert  into `portals`(`id`,`portalName`,`portalDesc`,`lastUpdatedBy`,`lastUpdate`,`version`) 
values (7,'Parent','Parent',1,'2014-03-03 18:30:00',0);

INSERT INTO `user_groups` (`userGroupName`, `lastUpdate`, `lastUpdatedBy`, `version`) 
VALUES ('Parent', '2016-08-29 00:00:00', '1', '0');

insert  into `roles`(`roleName`,`roleDesc`,`whetherDeletable`,`createdOn`,`whetherEditable`,`whetherDeleted`,`serialNumber`,`lastUpdatedBy`,`lastUpdate`,`version`) 
values ('Parent','Parent',false,'2016-08-29',false,false,'Parent',1,'2016-08-29',0);

SET @idRole=(SELECT MAX(id) FROM roles);
insert  into `role_portals`(`roleId`,`portalId`,`lastUpdate`,`lastUpdatedBy`) values (@idRole,7,'2016-08-29 00:00:00',1);


INSERT INTO 
`role_privileges`(`whetherOverrideAllowed`, `granted`, `featurePrivilegeId`, `roleId`, `lastUpdatedBy`, `lastUpdate`) 
VALUES 
('\0',true,2856,@idRole,1,'2016-08-29 00:00:00'),
('\0',true,2857,@idRole,1,'2016-08-29 00:00:00'),
('\0',true,2858,@idRole,1,'2016-08-29 00:00:00'),
('\0',true,2859,@idRole,1,'2016-08-29 00:00:00'),
('\0',true,2860,@idRole,1,'2016-08-29 00:00:00'),
('\0',true,2861,@idRole,1,'2016-08-29 00:00:00'),
('\0',true,2862,@idRole,1,'2016-08-29 00:00:00'),
('\0',true,2863,@idRole,1,'2016-08-29 00:00:00'),
('\0',true,2864,@idRole,1,'2016-08-29 00:00:00'),
('\0',true,2865,@idRole,1,'2016-08-29 00:00:00'),
('\0',true,2866,@idRole,1,'2016-08-29 00:00:00'),
('\0',true,2867,@idRole,1,'2016-08-29 00:00:00'),
('\0',true,2868,@idRole,1,'2016-08-29 00:00:00'),
('\0',true,2869,@idRole,1,'2016-08-29 00:00:00'),
('\0',true,2870,@idRole,1,'2016-08-29 00:00:00'),
('\0',true,2871,@idRole,1,'2016-08-29 00:00:00'),
('\0',true,2872,@idRole,1,'2016-08-29 00:00:00'),
('\0',true,2873,@idRole,1,'2016-08-29 00:00:00'),
('\0',true,2874,@idRole,1,'2016-08-29 00:00:00'),
('\0',true,2875,@idRole,1,'2016-08-29 00:00:00'),
('\0',true,2876,@idRole,1,'2016-08-29 00:00:00'),
('\0',true,2877,@idRole,1,'2016-08-29 00:00:00'),
('\0',true,2878,@idRole,1,'2016-08-29 00:00:00'),
('\0',true,2879,@idRole,1,'2016-08-29 00:00:00'),
('\0',true,2880,@idRole,1,'2016-08-29 00:00:00'),
('\0',true,2881,@idRole,1,'2016-08-29 00:00:00'),
('\0',true,2882,@idRole,1,'2016-08-29 00:00:00'),
('\0',true,2883,@idRole,1,'2016-08-29 00:00:00'),
('\0',true,2884,@idRole,1,'2016-08-29 00:00:00'),
('\0',true,2885,@idRole,1,'2016-08-29 00:00:00'),
('\0',true,2886,@idRole,1,'2016-08-29 00:00:00'),
('\0',true,2887,@idRole,1,'2016-08-29 00:00:00'),
('\0',true,2888,@idRole,1,'2016-08-29 00:00:00'),
('\0',true,2889,@idRole,1,'2016-08-29 00:00:00'),
('\0',true,2890,@idRole,1,'2016-08-29 00:00:00'),
('\0',true,2891,@idRole,1,'2016-08-29 00:00:00'),
('\0',true,2892,@idRole,1,'2016-08-29 00:00:00'),
('\0',true,2893,@idRole,1,'2016-08-29 00:00:00'),
('\0',true,2894,@idRole,1,'2016-08-29 00:00:00'),
('\0',true,2895,@idRole,1,'2016-08-29 00:00:00'),
('\0',true,2896,@idRole,1,'2016-08-29 00:00:00'),
('\0',true,2897,@idRole,1,'2016-08-29 00:00:00'),
('\0',true,2898,@idRole,1,'2016-08-29 00:00:00'),
('\0',true,2899,@idRole,1,'2016-08-29 00:00:00'),
('\0',true,2900,@idRole,1,'2016-08-29 00:00:00'),
('\0',true,2901,@idRole,1,'2016-08-29 00:00:00'),
('\0',true,2902,@idRole,1,'2016-08-29 00:00:00'),
('\0',true,2903,@idRole,1,'2016-08-29 00:00:00'),
('\0',true,2904,@idRole,1,'2016-08-29 00:00:00'),
('\0',true,2905,@idRole,1,'2016-08-29 00:00:00'),
('\0',true,2906,@idRole,1,'2016-08-29 00:00:00'),
('\0',true,2907,@idRole,1,'2016-08-29 00:00:00'),
('\0',true,2908,@idRole,1,'2016-08-29 00:00:00'),
('\0',true,2909,@idRole,1,'2016-08-29 00:00:00'),
('\0',true,2910,@idRole,1,'2016-08-29 00:00:00'),
('\0',true,2911,@idRole,1,'2016-08-29 00:00:00'),
('\0',true,2912,@idRole,1,'2016-08-29 00:00:00'),
('\0',true,2913,@idRole,1,'2016-08-29 00:00:00'),
('\0',true,2914,@idRole,1,'2016-08-29 00:00:00'),
('\0',true,2915,@idRole,1,'2016-08-29 00:00:00'),
('\0',true,2916,@idRole,1,'2016-08-29 00:00:00'),
('\0',true,2917,@idRole,1,'2016-08-29 00:00:00'),
('\0',true,2918,@idRole,1,'2016-08-29 00:00:00'),
('\0',true,2919,@idRole,1,'2016-08-29 00:00:00'),
('\0',true,2920,@idRole,1,'2016-08-29 00:00:00'),
('\0',true,2921,@idRole,1,'2016-08-29 00:00:00'),
('\0',true,2922,@idRole,1,'2016-08-29 00:00:00'),
('\0',true,2923,@idRole,1,'2016-08-29 00:00:00'),
('\0',true,2924,@idRole,1,'2016-08-29 00:00:00'),
('\0',true,2925,@idRole,1,'2016-08-29 00:00:00'),
('\0',true,2926,@idRole,1,'2016-08-29 00:00:00'),
('\0',true,2927,@idRole,1,'2016-08-29 00:00:00'),
('\0',true,2928,@idRole,1,'2016-08-29 00:00:00'),
('\0',true,2929,@idRole,1,'2016-08-29 00:00:00'),
('\0',true,2930,@idRole,1,'2016-08-29 00:00:00'),
('\0',true,2931,@idRole,1,'2016-08-29 00:00:00'),
('\0',true,2932,@idRole,1,'2016-08-29 00:00:00'),
('\0',true,2933,@idRole,1,'2016-08-29 00:00:00'),
('\0',true,2934,@idRole,1,'2016-08-29 00:00:00'),
('\0',true,2935,@idRole,1,'2016-08-29 00:00:00'),
('\0',true,2936,@idRole,1,'2016-08-29 00:00:00'),
('\0',true,2937,@idRole,1,'2016-08-29 00:00:00'),
('\0',true,2938,@idRole,1,'2016-08-29 00:00:00'),
('\0',true,2939,@idRole,1,'2016-08-29 00:00:00'),
('\0',true,2940,@idRole,1,'2016-08-29 00:00:00'),
('\0',true,2941,@idRole,1,'2016-08-29 00:00:00'),
('\0',true,2942,@idRole,1,'2016-08-29 00:00:00'),
('\0',true,2943,@idRole,1,'2016-08-29 00:00:00'),
('\0',true,2944,@idRole,1,'2016-08-29 00:00:00'),
('\0',true,2945,@idRole,1,'2016-08-29 00:00:00'),
('\0',true,2946,@idRole,1,'2016-08-29 00:00:00'),
('\0',true,2947,@idRole,1,'2016-08-29 00:00:00'),
('\0',true,2948,@idRole,1,'2016-08-29 00:00:00'),
('\0',true,2949,@idRole,1,'2016-08-29 00:00:00'),
('\0',true,2950,@idRole,1,'2016-08-29 00:00:00'),
('\0',true,2951,@idRole,1,'2016-08-29 00:00:00'),
('\0',true,2952,@idRole,1,'2016-08-29 00:00:00'),
('\0',true,2953,@idRole,1,'2016-08-29 00:00:00'),
('\0',true,2954,@idRole,1,'2016-08-29 00:00:00'),
('\0',true,2955,@idRole,1,'2016-08-29 00:00:00'),
('\0',true,2956,@idRole,1,'2016-08-29 00:00:00'),
('\0',true,2957,@idRole,1,'2016-08-29 00:00:00'),
('\0',true,2958,@idRole,1,'2016-08-29 00:00:00'),
('\0',true,2959,@idRole,1,'2016-08-29 00:00:00'),
('\0',true,2960,@idRole,1,'2016-08-29 00:00:00'),
('\0',true,2961,@idRole,1,'2016-08-29 00:00:00'),
('\0',true,2962,@idRole,1,'2016-08-29 00:00:00'),
('\0',true,2963,@idRole,1,'2016-08-29 00:00:00'),
('\0',true,2964,@idRole,1,'2016-08-29 00:00:00'),
('\0',true,2965,@idRole,1,'2016-08-29 00:00:00'),
('\0',true,2967,@idRole,1,'2016-08-29 00:00:00'),
('\0',true,2968,@idRole,1,'2016-08-29 00:00:00'),
('\0',true,2969,@idRole,1,'2016-08-29 00:00:00'),
('\0',true,2970,@idRole,1,'2016-08-29 00:00:00'),
('\0',true,2971,@idRole,1,'2016-08-29 00:00:00'),
('\0',true,2972,@idRole,1,'2016-08-29 00:00:00'),
('\0',true,2973,@idRole,1,'2016-08-29 00:00:00'),
('\0',true,2974,@idRole,1,'2016-08-29 00:00:00'),
('\0',true,2975,@idRole,1,'2016-08-29 00:00:00'),
('\0',true,2976,@idRole,1,'2016-08-29 00:00:00'),
('\0',true,2977,@idRole,1,'2016-08-29 00:00:00'),
('\0',true,2978,@idRole,1,'2016-08-29 00:00:00'),
('\0',true,2979,@idRole,1,'2016-08-29 00:00:00');

SET @idNationalitySerialNumber=(SELECT MAX(id) FROM nationalities);
insert into nationalities values(@idNationalitySerialNumber+1,'Indian','Indian',CURDATE(),1);

/*********Account Type********/
insert into account_type values(1,'Saving','Saving','2017-05-01 12:00:00',1);
/*********Visitor Category********/
insert into sg_visitor_category values(1,'Parent/Guardian','Parent/Guardian','2017-02-17 12:00:00',1);
insert into sg_visitor_category values(2,'Lead','Lead','2018-03-14 12:00:00',1);
INSERT INTO `sg_visitor_category` VALUES (3,'Student','Student','2018-03-14 12:00:00', '1');
INSERT INTO `sg_visitor_category` VALUES (4,'Employee','Employee','2018-03-14 12:00:00', '1');
INSERT INTO `sg_visitor_category` VALUES (5,'Applicant','Applicant','2018-03-14 12:00:00', '1');

-- seed data for employee/student id cards
INSERT INTO identity_type (id, itemCode, itemValue, lastUpdate, lastUpdatedBy) 
VALUES (1,'SSN', 'SSN', NOW(), '1'), (2,'Passport', 'Passport', NOW(), '1');